<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/database.php 
	# Description: 
	# Write by: Le Hung
	# Start time: November 06, 2007
	# Last update:  
	*/

	include_once("./logged.php");
	require_once("./classes/pclzip.lib.php");
	require_once("./backup.html.php");
	require_once("../languages/".$_SESSION['folder']."/database.php");
	

	$dir_fs_www_root=path_root();
	$local_backup_path=$dir_fs_www_root."administrator/backups";
	$path_root=$dir_fs_www_root;
	
	$file	= get_param($_POST, "file", null);
	$upfile	= get_param($_FILES, "upfile", null);
	
	$action=trim(strtolower(get_param($_REQUEST, 'action', 'backup' )));

	switch ($action)
	{			
		case "backup_data":
			save_data($_POST['tables'], $_POST['OutType'], $_POST['OutDest'], $_POST['toBackUp'], $_SERVER['HTTP_USER_AGENT'], $local_backup_path);
			break;
		
		default:
			header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
			backup_form($db);
			break;
	}//end switch

	function backup_form(&$db)
	{
		global $draw_html;
		$sql_exc_sel = array($draw_html->make_option('all', ALL_TABLES));
		$rows=$db->get_table_list();
		foreach ($rows as $row) 
		{
			$sql_exc_sel[]=$draw_html->make_option($row);
		}//end foreach
		
		$tablelist = $draw_html->selectbox($sql_exc_sel, 'tables[]', 'class="inputbox" size="4" multiple="multiple"', 'value', 'text', 'all');
		
		html_database::backup_form($tablelist);
	}//end function


	function save_data($tables, $OutType, $OutDest, $toBackUp, $UserAgent, $local_backup_path) 
	{
		global $db, $action, $path_root;

		if (!$tables[0])
		{
			header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
			html_database::message("Error! No database table(s) specified. Please select at least one table and re-try.</p>", "", $action);
			return;
		}//end if

		if (ereg('Opera(/| )([0-9].[0-9]{1,2})', $UserAgent)) 
		{
			$UserBrowser = "Opera";
		}elseif (ereg('MSIE ([0-9].[0-9]{1,2})', $UserAgent)){
			$UserBrowser = "IE";
		}else{
			$UserBrowser = '';
		}//end if

		if ($OutType == "bzip") 
		{
			$filename = date("jmYHis") . ".bz2";
			$mime_type = 'application/x-bzip';
		}elseif ($OutType == "gzip"){
			$filename = date("jmYHis") . ".sql.gz";
			$mime_type = 'application/x-gzip';
		}elseif($OutType == "zip"){
			$filename = date("jmYHis") . ".zip";
			$mime_type = 'application/x-zip';
		}elseif ($OutType == "html"){
			$filename = date("jmYHis") . ".html";
			$mime_type = ($UserBrowser == 'IE' || $UserBrowser == 'Opera') ? 'application/octetstream' : 'application/octet-stream';
		}else{
			$filename = date("jmYHis") . ".sql";
			$mime_type = ($UserBrowser == 'IE' || $UserBrowser == 'Opera') ? 'application/octetstream' : 'application/octet-stream';
		}//end if

		if ($tables[0] == "all") 
		{
			array_pop($tables);
			$tables = array_merge($tables, $db->get_table_list());
		}//end if

		if ($toBackUp!="data")
		{
			$CreateTable=$db->create_table($tables);
		}//end if

		if ($toBackUp!="structure")
		{
			$FieldType=$db->get_table_fields($tables);
		}//end if

		$OutBuffer = "";
		if ($OutType == 'html') 
		{
		}else{
			$OutBuffer .= "#\n";
			$OutBuffer .= "# MySQL-Dump\n";
			$OutBuffer .= "# ".SITENAME."\n";
			$OutBuffer .= "#\n";
			$OutBuffer .= "# Host: ".HOSTNAME."\n";
			$OutBuffer .= "# Generation Time: ".date("M j, Y \a\\t H:i"). "\n";
			$OutBuffer .= "# Server version: ".mysql_get_server_info()."\n";
			$OutBuffer .= "# PHP Version: ".phpversion()."\n";
			$OutBuffer .= "# Database :`".DB_DATABASE. "`\n# --------------------------------------------------------\n";
		}//end if

		if (($OutType == 'html') && ($OutDest=='screen')) header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
		
		foreach ($tables as $tblval) 
		{
			if ($toBackUp != "data")
			{
				if ($OutType == 'html') 
				{
				}else{
					$OutBuffer .= "#\n# Table structure for table `$tblval`\n";
					$OutBuffer .= "#\nDROP table IF EXISTS $tblval;\n";
					$OutBuffer .= $CreateTable[$tblval][0].";\r\n";
				}//end if
			}//end if

			if ($toBackUp != "structure") 
			{
				if ($OutType == 'html') 
				{
					$OutBuffer .= "<div align=\"left\">";
					$OutBuffer .= "<table cellspacing=\"1\" cellpadding=\"2\" border=\"0\" bgcolor=\"#B2B2B2\">";
					$sql_sel="SELECT * FROM $tblval";
					//echo $sql_sel;
					//$rows = $db->load_object_list($sql_sel);
					$db->set_query($sql_sel);
					$rows = $db->load_object_list();

					$OutBuffer .= "<tr bgcolor=\"#FFFFFF\"><th colspan=\"".count( @array_keys( @$rows[0] ) )."\">`$tblval`</th></tr>";
					
					if (count($rows)) 
					{
						$OutBuffer .= "<tr bgcolor=\"#FFFFFF\">";
						foreach($rows[0] as $key => $value) 
						{
							$OutBuffer .= "<th>$key</th>";
						}//end foreach
						$OutBuffer .= "</tr>";
					}//end if

					//print_r($rows);
					foreach($rows as $row)
					{
						$OutBuffer .= "<tr bgcolor=\"#FFFFFF\">";
						$arr = ObjectToArray($row);
						foreach($arr as $key => $value)
						{
							$value = addslashes( $value );
							$value = str_replace( "\n", '\r\n', $value );
							$value = str_replace( "\r", '', $value );
							$value = htmlspecialchars( $value );

							if (preg_match ("/\b" . $FieldType[$tblval][$key] . "\b/i", "DATE TIME DATETIME CHAR VARCHAR TEXT TINYTEXT MEDIUMTEXT LONGTEXT BLOB TINYBLOB MEDIUMBLOB LONGBLOB ENUM SET"))
							{
								$OutBuffer .= "<td>'$value'</td>";
							}else{
								$OutBuffer .= "<td>$value</td>";
							}//end if
						}//end foreach
						$OutBuffer .= "</tr>";
					}//end foreach
					
					$OutBuffer .= "</table></div><br />";
				}else{
					$OutBuffer .= "#\n# Dumping data for table `$tblval`\n#\n";
					$sql_sel="SELECT * FROM $tblval";
					$db->set_query($sql_sel);
					$rows = $db->load_object_list();
					//$rows = $db->load_object_list($sql_sel);
					foreach($rows as $row)
					{
						$InsertDump = "INSERT INTO $tblval VALUES (";
						$arr = object_to_array($row);
						foreach($arr as $key => $value)
						{
							$value = addslashes( $value );
							$value = str_replace( "\n", '\r\n', $value );
							$value = str_replace( "\r", '', $value );
							if (preg_match ("/\b" . $FieldType[$tblval][$key] . "\b/i", "DATE TIME DATETIME CHAR VARCHAR TEXT TINYTEXT MEDIUMTEXT LONGTEXT BLOB TINYBLOB MEDIUMBLOB LONGBLOB ENUM SET"))
							{
								$InsertDump .= "'$value',";
							}else{
								$InsertDump .= "$value,";
							}//end if
						}//end foreach
						
						$OutBuffer .= rtrim($InsertDump,',') . ");\n";
					}//end foreach
				}//end if
			}//end if
		}//end foreach

		if ($OutDest == "remote") 
		{
		
			ob_end_clean();
			ob_start();
			header('Content-Type: ' . $mime_type);
			header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');

			if ($UserBrowser == 'IE') 
			{
				header('Content-Disposition: inline; filename="' . $filename . '"');
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
			}else{
				header('Content-Disposition: attachment; filename="' . $filename . '"');
				header('Pragma: no-cache');
			}//end if
			
			if ($OutType == "sql") 
			{
				echo $OutBuffer;
			}else if ($OutType == "zip"){
				include "./classes/zip.lib.php";
				$zipfile = new zipfile();
				$zipfile -> addFile($OutBuffer, $filename . ".sql");
				echo $zipfile->file();
			}else if($OutType == "gzip"){
				echo gzencode($OutBuffer);
			}//end if

			ob_end_flush();
			ob_start();
			exit();
		}//end if

		if ($OutDest == "screen") 
		{
			if ($OutType == "html") 
			{
				echo $OutBuffer;
			}else{
				$OutBuffer = str_replace("<","&lt;",$OutBuffer);
				$OutBuffer = str_replace(">","&gt;",$OutBuffer);
				header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
?>
				<form>
				<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0">
				  <tr>
					<td align="center">
				<textarea rows="20" cols="100" name="sqldump"  style="background-color:#e0e0e0"><?php echo $OutBuffer;?></textarea>
					</td>
				  </tr>
				  <tr><td align="center"><input type="button" onclick="javascript:this.form.sqldump.focus();this.form.sqldump.select();" class="button" value="Select All" /></td></tr>
				</table>
				</form>
<?php
			}//end if
		}elseif ($OutType == "sql"){
			if ($OutDest == "local") 
			{
				$fp = fopen("$local_backup_path/$filename", "w");

				if (!$fp) 
				{
					header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
					html_database::message(BACKUP_FAILURE."!<br />File $local_backup_path/$filename ".NOT_WRITABLE."<br />".CONTACT_WEBMASTER."!","", $action);
					return;
				}else{
					fwrite($fp, $OutBuffer);
					fclose($fp);
					header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
					html_database::message(BACKUP_SUCCESSFUL."<br />$local_backup_path/$filename","", $action);
					return;
				}//end if
			}else{
				echo $OutBuffer;
			}//end if
		}elseif ($OutType == "bzip"){
			if (function_exists('bzcompress')) 
			{
				if ($OutDest == "local") 
				{
					$fp = fopen("$local_backup_path/$filename", "wb");
					if (!$fp) 
					{
						echo "<p align=\"center\" class=\"error\">".BACKUP_FAILURE."!<br />File $local_backup_path/$filename ".NOT_WRITABLE."<br />".CONTACT_WEBMASTER."!</p>";
					}else{
						fwrite($fp, bzcompress($OutBuffer));
						fclose($fp);
						header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
						html_database::message(BACKUP_SUCCESSFUL."<br />$local_backup_path/$filename","", $action);
						return;
					}//end if
				}else{
					echo bzcompress($OutBuffer);
				}//end if
			}else{
				echo $OutBuffer;
			}//end if
		}elseif ($OutType == "gzip"){
			if (function_exists('gzencode')) 
			{
				if ($OutDest == "local") 
				{
					$fp = gzopen("$local_backup_path/$filename", "wb");
					if (!$fp) 
					{
						header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
						html_database::message(BACKUP_FAILURE."!<br />File $local_backup_path/$filename ".NOT_WRITABLE."<br />".CONTACT_WEBMASTER,"", $action);
						return;
					}else{
						gzwrite($fp,$OutBuffer);
						gzclose($fp);
						header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
						html_database::message(BACKUP_SUCCESSFUL."<br />$local_backup_path/$filename","", $action);
						return;
					}//end if
				}else{
					echo gzencode($OutBuffer);
				}//end if
			}else{
				echo $OutBuffer;
			}//end if
		}elseif ($OutType == "zip"){
			if (function_exists('gzcompress')) 
			{
				include "./classes/zip.lib.php";
				$zipfile = new zipfile();
				$zipfile -> addFile($OutBuffer, $filename . ".sql");
				
				if ($OutDest == "local") 
				{
					$fp = fopen("$local_backup_path/$filename", "wb");
					if (!$fp) 
					{
						header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
						html_database::message(BACKUP_FAILURE."!<br />File $local_backup_path/$filename ".NOT_WRITABLE."<br />".CONTACT_WEBMASTER."!","", $action);
						return;
					}else{
						fwrite($fp, $zipfile->file());
						fclose($fp);
						header_page(MN_DATABASE_AREAS, MN_BACKUP, false);
						html_database::message(BACKUP_SUCCESSFUL."<br />$local_backup_path/$filename","", $action);
						return;
					}//end if
				}else{
					echo $zipfile->file();
				}//end if
			}else{
				echo $OutBuffer;
			}//end if
		}//end if
	}//end function
	
	function deldir($dir)
	{
		$current_dir = opendir($dir);
		while($entryname = readdir($current_dir))
		{
    		if(is_dir("$dir/$entryname") and ($entryname != "." and $entryname!=".."))
    		{
				deldir("${dir}/${entryname}");
			}elseif($entryname != "." and $entryname!=".."){
				unlink("${dir}/${entryname}");
			}//end if
		}//end while
		
		closedir($current_dir);
		rmdir($dir);
	}//end function
	
	function path_root()
	{
		$script_filename = getenv("PATH_TRANSLATED");
		if (empty($script_filename)) $script_filename = getenv("SCRIPT_FILENAME");
		
		$script_filename = str_replace('\\', '/', $script_filename);
		$script_filename = str_replace('//', '/', $script_filename);
	
		$dir_fs_www_root_array = explode('/', dirname($script_filename));
		$dir_fs_www_root = array();
		for ($i=0, $n=sizeof($dir_fs_www_root_array)-1; $i<$n; $i++) 
		{
			$dir_fs_www_root[] = $dir_fs_www_root_array[$i];
		}//end for
		$dir_fs_www_root = implode('/', $dir_fs_www_root) . '/';
		return $dir_fs_www_root;
	}//end function

	footer_page();
?>