<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : administrator/classes/draw_html.php
	# Description: The draw_html class is  meant to simplify the task of drawing 
				   html code for selectbox, etc... 
	# Write by: Le Hung
	# Start time: September 17, 2007
	# Last update: 
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class draw_html
	{
		function draw_html()
		{
		
		}//end function

		function make_option($value, $text="") 
		{
			$result = new stdClass;
			$result->value = $value;
			$result->text = $text ? $text : $value;
			return $result;
		}//end function

		function selectbox(&$arr, $name, $attribs, $key, $text, $selected) 
		{
			reset($arr);
			$html = '<select name="'.$name.'" '.$attribs.'>';
			for ($i=0, $n=count($arr); $i < $n; $i++) 
			{
				$k = $arr[$i]->$key;
				$t = $arr[$i]->$text;
			
				$sel = "";
				if (is_array($selected)) 
				{
					foreach ($selected as $obj) 
					{
						$k2 = $obj->$key;
						if ($k == $k2) 
						{
							$sel = ' selected="selected"';
							break;
						}//end if
					}//end foreach
				}else{
					$sel = ($k == $selected ? ' selected="selected"' : '');
				}//end if
				$html .= '<option value="'.$k.'" '.$sel.'>' . $t . '</option>';
			}//and for
			$html .= '</select>';
			return $html;
		}//end function

		function select_integer_up($start, $end, $inc, $name, $attribs, $selected="", $format="") 
		{
			$start = intval($start);
			$end = intval($end);
			$inc = intval($inc);
			$arr = array();
			for ($i=$start; $i <= $end; $i+=$inc) 
			{
				$fi = $format ? sprintf("$format", $i) : "$i";
				$arr[] = $this->make_option($fi, $fi);
			}//end for
		
			return $this->selectbox($arr, $name, $attribs, 'value', 'text', $selected);
		}//end function

		function select_integer_down($start, $end, $inc, $name, $attribs, $selected='', $format="") 
		{
			$start = intval($start);
			$end = intval($end);
			$inc = intval($inc);
			$arr = array();
			for ($i=$start; $i >= $end; $i-=$inc) 
			{
				$fi = $format ? sprintf("$format", $i) : "$i";
				$arr[] = $this->make_option($fi, $fi);
			}//end for
		
			return $this->selectbox($arr, $name, $attribs, 'value', 'text', $selected);
		}//end function
		
		function draw_selectbox_after_save($attribs='', $selected='')
		{
			$arr = array(
					$this->make_option('', TO_PREVIOUS),
					$this->make_option('convert', TO_CONVERT),
					$this->make_option('addmore', TO_INSERT)
					);
			return $this->selectbox($arr, 'goto', $attribs, 'value', 'text', $selected);
		}//end function

		function draw_error_form($width='98%', $error, $title=WARNING)
		{
			$html='<table width="'.$width.'" border="0" cellspacing="0" cellpadding="0" align="center"><tr><td>';
			$html.='<fieldset style="width:'.$width.'" class="boder_greyish">';
			$html.='<legend align="left" class="warning">'.$title.'</legend>';
			$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">';
			$html.='<tr>';
			if (is_array($error))
			{
				$html.='<td width="80" align="center"><img src="./images/warning.gif" width="32" height="32" align="absmiddle" hspace="5" vspace="0"></td>';
				$html.='<td>';
				$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">';
				for ($i=0, $n=count($error); $i<$n; $i++)
				{
					$html.='<tr>';
					$html.='<td class="error">'.$error[$i].'</td>';
					$html.='</tr>';
				}//end for
				$html.='</table>';
				$html.='</td>';
			}else{
				$html.='<td width="80" align="center"><img src="./images/warning.gif" width="32" height="32" align="absmiddle" hspace="5" vspace="0"></td>';
				$html.='<td class="error">'.$error.'</td>';
			}//end if
			$html.='</tr>';
			$html.='</table>';
			$html.='</fieldset>';
			$html.='</td></tr></table>';
			//$html.='<br><br>';
			return $html;
		}//end function

		function draw_button($onclick='')
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<a class="toolbar" href="JavaScript:submit_button(\'adminForm\', \'save\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_save.gif" width="70" height="26" border="0" id="imgSave" onmouseover="MM_swapImage(\'imgSave\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_save_o.gif\',1)" onmouseout="MM_swapImgRestore()" '.$onclick.' /></a> <a href="JavaScript:submit_button(\'adminForm\', \'cancel\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_cancel.gif" width="70" height="26" border="0" id="imgCancel" onmouseover="MM_swapImage(\'imgCancel\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_cancel_o.gif\',1)" onmouseout="MM_swapImgRestore()" /></a>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function

		function draw_button_save()
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<a class="toolbar" href="JavaScript:submit_button(\'adminForm\', \'save\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_save.gif" width="70" height="26" border="0" id="imgSave" onmouseover="MM_swapImage(\'imgSave\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_save_o.gif\',1)" onmouseout="MM_swapImgRestore()" /></a>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function

		function draw_reply($onclick='')
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<a class="toolbar" href="JavaScript:submit_button(\'adminForm\', \'save\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_reply.gif" width="70" height="26" border="0" id="imgSave" onmouseover="MM_swapImage(\'imgSave\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_reply_o.gif\',1)" onmouseout="MM_swapImgRestore()" '.$onclick.' /></a> <a href="JavaScript:submit_button(\'adminForm\', \'cancel\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_cancel.gif" width="70" height="26" border="0" id="imgCancel" onmouseover="MM_swapImage(\'imgCancel\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_cancel_o.gif\',1)" onmouseout="MM_swapImgRestore()" /></a>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function
		
		function draw_forward($onclick='')
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<a class="toolbar" href="JavaScript:submit_button(\'adminForm\', \'save\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_forward.gif" width="90" height="26" border="0" id="imgSave" onmouseover="MM_swapImage(\'imgSave\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_forward_o.gif\',1)" onmouseout="MM_swapImgRestore()" '.$onclick.' /></a> <a href="JavaScript:submit_button(\'adminForm\', \'cancel\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_cancel.gif" width="70" height="26" border="0" id="imgCancel" onmouseover="MM_swapImage(\'imgCancel\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_cancel_o.gif\',1)" onmouseout="MM_swapImgRestore()" /></a>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function
		
		
		
		function draw_button_backup()
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<a class="toolbar" href="JavaScript:submit_button(\'adminForm\', \'backup_data\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_backup.gif" width="80" height="26" border="0" id="imgBackup" onmouseover="MM_swapImage(\'imgBackup\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_backup_o.gif\',1)" onmouseout="MM_swapImgRestore()" /></a>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function

		function draw_button_restore()
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<a class="toolbar" href="JavaScript:submit_button(\'adminForm\', \'restore_data\')"><img src="../languages/'.$_SESSION['folder'].'/images/bt_restore.gif" width="90" height="26" border="0" id="imgRestore" onmouseover="MM_swapImage(\'imgRestore\',\'\',\'../languages/'.$_SESSION['folder'].'/images/bt_restore_o.gif\',1)" onmouseout="MM_swapImgRestore()" /></a>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function

		function draw_help_note()
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td><strong><u>'.NOTE.':</u></strong>: '.REQUEST_INPUT.'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td height="15"><img src="./images/trans.gif" width="1" height="1"></td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td>'.INTRODUCTION.':</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function

		function draw_save_cancel_note()
		{
			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td>';
			$html.='<ul><li>'.BUTTON_SAVE_NOTE.'</li>';
			$html.='<li>'.BUTTON_CANCEL_NOTE.'</li></ul>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function
		
		function draw_form_input_photo($number=1)
		{
			//echo "<pre>";print_r($value);echo "</pre>";
			$j=0;

			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			for ($i=0; $i<$number; $i++)
			{
				if ($number>1) $j=intval($i)+1;
				else $j='';
				$html.='<tr><td class="bold" id="image_style_'.$i.'">'.FILE_NAME.' '.$j.':<br />';
				$html.='<input name="image[]" type="file" id="image_'.$i.'" value="" size="53" class="inputbox" />';
				$html.='<input name="image_error_'.$i.'" type="hidden" id="image_error_'.$i.'" value="'.FILE_NAME_EMPTY.'" />';
				$html.='</td></tr>';
			}//end for	
			$html.='</table>';
			return $html;
		}//end function

		function draw_form_input_photo_text($number=1)
		{
			//echo "<pre>";print_r($value);echo "</pre>";
			$j=0;

			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			for ($i=0; $i<$number; $i++)
			{
				if ($number>1) $j=intval($i)+1;
				else $j='';
				$html.='<tr><td class="bold" id="text_style_'.$i.'">'.TITLE.' '.$j.':<br />';
				$html.='<input name="title[]" type="text" id="title_'.$i.'" value="" size="53" class="inputbox" />';
				$html.='<input name="title_error_'.$i.'" type="hidden" id="title_error_'.$i.'" value="'.NAME_EMPTY.'" />';
				$html.='</td></tr>';
			}//end for	
			$html.='</table>';
			return $html;
		}//end function


		function draw_form_input_photo_error($number=1, $rows=array())
		{
			$j=0;
			
			//echo '<pre>';print_r($rows); echo '</pre>';

			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			foreach ($rows as $i=>$row)
			{
				if ($number>1) $j=intval($i)+1;
				else $j='';
				$html.='<tr><td class="bold" id="image_style_'.$i.'">'.FILE_NAME.' '.$j.':<br />';
				$html.='<input name="image[]" type="file" id="image_'.$i.'" value="" size="53" class="inputbox" />';
				$html.='<input name="image_error_'.$i.'" type="hidden" id="image_error_'.$i.'" value="'.FILE_NAME_EMPTY.'" />';
				$html.='</td></tr>';
			}//end for	
			$html.='</table>';
			return $html;
		}//end function
		
		
		function draw_form_input_text_error($number=1, $rows=array())
		{
			$j=0;
			
			//echo '<pre>';print_r($rows); echo '</pre>';

			$html='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			foreach ($rows as $i=>$row)
			{
				if ($number>1) $j=intval($i)+1;
				else $j='';
				$html.='<tr><td class="bold" id="title_style_'.$i.'">'.TITLE.' '.$j.':<br />';
				$html.='<input name="title[]" type="text" id="title_'.$i.'" value="" size="53" class="inputbox" />';
				$html.='<input name="title_error_'.$i.'" type="hidden" id="title_error_'.$i.'" value="'.NAME_EMPTY.'" />';
				$html.='</td></tr>';
			}//end for	
			$html.='</table>';
			return $html;
		}//end function



		function draw_note_active($member=false)
		{
			$not_active=($member==true)?MEMBER_NOT_ACTIVE:RECORD_NOT_ACTIVE;
			$active=($member==true)?MEMBER_ACTIVE:RECORD_ACTIVE;
			$html='<table width="90%" border="0" cellspacing="0" cellpadding="0" align="center">';
			$html.='<tr>';
			$html.='<td>-- '.$not_active.'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td><img src="./images/tick.png" width="15" height="12" /> '.$active.'</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function
		function draw_note_contact()
		{
			$not_reply='Not reply';
			$reply='Replied';
			$html='<table width="90%" border="0" cellspacing="0" cellpadding="0" align="center">';
			$html.='<tr>';
			$html.='<td>-- '.$not_reply.'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td><img src="./images/tick.png" width="15" height="12" /> '.$reply.'</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end function
		
	}//end class
?>