<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/classes/members.php 
	# Description: The members class is meant to simplify the task of module members.
	# Write by: Le Hung
	# Start time: November 06, 2007
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class groups_member extends access_database
	{
		var $id = null;
		var $group = null;
		var $note = null;
		var $create_by = null;
		var $create_date = null;
		var $modify_by = null;
		var $modify_date = null;
		var $active = null;

		function groups_member(&$db) 
		{
			$this->access_database( '`#__groups_member`', 'id', $db);
		}//end function

		function check()
		{	
			$this->_db->set_query("SELECT `id` FROM `#__groups_member` "
									."\nWHERE LOWER(`group`)='".trim(strtolower($this->group))."'");
			$xid = intval( $this->_db->load_result());
			if ($xid && $xid != intval( $this->id )) 
			{
				$this->_error = sprintf(GROUP_EXIST, $this->group);
				return false;
			}//end if

			return true;
		}//end function
	}//end class

	class members extends access_database
	{
		var $id = null;
		var $group_id = null;
		var $fullname = null;
		var $code = null;
		var $sex = null;
		var $birthday = null;
		var $company = null;
		var $address = null;
		var $address2 = null;
		var $phone = null;
		var $mobile = null;
		var $fax = null;
		var $email = null;
		var $username = null;
		var $password = null;
		var $note = null;
		var $date_created = null;
		var $last_visit = null;
		var $date_visit = null;
		var $cooked = null;
		var $timestamp = null;
		var $active = null;

		function members(&$db) 
		{
			$this->access_database( '`#__members`', 'id', $db);
		}//end function

		function check()
		{	
			if (eregi( "[\<|\>|\"|\'|\%|\;|\(|\)|\&|\+|\-]", $this->username) || strlen( $this->username) < 5) 
			{
				$this->_error = sprintf(_VALID_AZ09, USERNAME, 4);
				return false;
			}//end if
			
			$this->_db->set_query("SELECT `id` FROM `#__members` "
									."\nWHERE LOWER(`username`)=LOWER('".$this->username."') AND `group_id`=".$this->group_id);
			//die($this->_db->get_query());
			$xid = intval( $this->_db->load_result());
			if ($xid && $xid != intval( $this->id )) 
			{
				$this->_error = sprintf(ACCOUNT_EXIST, $this->username);
				return false;
			}//end if

			$this->_db->set_query("SELECT `id` FROM `#__members` "
									."\nWHERE `email`='".$this->email."' AND `group_id`=".$this->group_id);
			$xid = intval($this->_db->load_result());
			if ($xid && $xid != intval( $this->id )) 
			{
				$this->_error = sprintf(_REGWARN_EMAIL_INUSE, $this->email);
				return false;
			}//end if
			return true;
		}//end function

		function get_code()
		{
			$this->_db->set_query("SELECT `code` FROM `#__members` ORDER BY `code` DESC");
			$row=$this->_db->load_result();

			if (!$row) $code="70904001";
			else $code=$row+1;
			return sprintf('%d'.$code, 0);
		}//end function
	}//end class
?>