<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/classes/pages.php 
	# Description: The pages class is meant to simplify the task of partition page.
	# Write by: Le Hung
	# Start time: October 22, 2007
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');
	class pages
	{
		var $limitstart = null;
		var $limit = null;
		var $total = null;

		function pages($total, $limitstart, $limit) 
		{
			$this->total = intval($total);
			$this->limitstart = max($limitstart, 0);
			$this->limit = max($limit, 5);
			
			if ($this->limit > $this->total) 
			{
				$this->limitstart = 0;
			}//end if

			if (($this->limit-1)*$this->limitstart > $this->total) 
			{
				$this->limitstart -= $this->limitstart % $this->limit;
			}//end if
		}//end function

		function make_option($value, $text='') 
		{
			$obj = new stdClass;
			$obj->value = $value;
			$obj->text = $text ? $text : $value;
			return $obj;
		}//end function

		function select_list(&$arr, $name, $attribute, $key, $text, $selected) 
		{
			reset($arr);
			$html = "\n<select name=\"$name\" $attribute>";
			for ($i=0, $n=count($arr); $i<$n; $i++) 
			{
				$k = $arr[$i]->$key;
				$t = $arr[$i]->$text;
			
				$sel = '';
				if (is_array($selected)) 
				{
					foreach ($selected as $obj) 
					{
						$k2 = $obj->$key;
						if ($k == $k2) 
						{
							$sel = " selected=\"selected\"";
							break;
						}//end if
					}//end foreach
				}else{
					$sel = ($k == $selected ? " selected=\"selected\"" : '');
				}//end if
				$html .= "\n\t<option value=\"".$k."\"$sel>" . $t . "</option>";
			}//end for
			$html .= "\n</select>\n";
			return $html;
		}//end function

		function limit_box() 
		{
			global $field_sort, $sort_by;

			$limits = array();
			for ($i=5; $i <= 30; $i+=5) 
			{
				$limits[] = $this->make_option("$i");
			}
			$limits[] = $this->make_option("50");
			$limits[] = $this->make_option("100");

			echo $this->select_list( $limits, 'limit', 'class="inputbox" size="1" onchange="document.adminForm.submit();"',
			'value', 'text', $this->limit );
			echo '<input type="hidden" name="limitstart" value="'.$this->limitstart.'" />';
			echo '<input type="hidden" name="field_sort" value="'.$field_sort.'" />';
			echo '<input type="hidden" name="sort_by" value="'.$sort_by.'" />';
		}//end function

		function pages_counter() 
		{
			$from_result = $this->limitstart+1;
			if ($this->limitstart + $this->limit < $this->total) 
			{
				$to_result = $this->limitstart + $this->limit;
			}else{
				$to_result = $this->total;
			}//end if

			if ($this->total > 0) 
			{
				echo "\n<strong>".RESULTS." ". $from_result . "</strong> - <strong>" . $to_result . " ". OF ." ". $this->total."</strong>";
			}else{
				echo NO_RECORDS_FOUND;
			}//end if
		}//end function
		
		function pages_links() 
		{
			$displayed_pages = 10;
			$total_pages = ceil($this->total / $this->limit);
			$this_page = ceil(($this->limitstart+1) / $this->limit);
			$start_loop = (floor(($this_page-1)/$displayed_pages))*$displayed_pages+1;
			
			if ($start_loop + $displayed_pages - 1 < $total_pages) 
			{
				$stop_loop = $start_loop + $displayed_pages - 1;
			}else{
				$stop_loop = $total_pages;
			}//end if

			if ($this_page > 1) 
			{
				$page = ($this_page - 2) * $this->limit;
				echo "\n&laquo;&laquo; <a href=\"#beg\" class=\"pagenav\" title=\"".PAGE_START."\" onclick=\"JavaScript: document.adminForm.limitstart.value=0; document.adminForm.submit();\">".PAGE_START."</a>";
				echo "\n &laquo; <a href=\"#prev\" class=\"pagenav\" title=\"".PAGE_PREVIOUS."\" onclick=\"JavaScript: document.adminForm.limitstart.value=$page; document.adminForm.submit();\">".PAGE_PREVIOUS."</a>";
			}else{
				echo "\n&laquo;&laquo; ".PAGE_START;
				echo "\n &laquo; ".PAGE_PREVIOUS;
			}//end if

			for ($i=$start_loop; $i <= $stop_loop; $i++) 
			{
				$page = ($i - 1) * $this->limit;
				if ($i == $this_page) 
				{
					echo "\n <span class=\"active\">$i</span>";
				}else{
					echo "\n <a href=\"#$i\" class=\"pagenav\" onclick=\"JavaScript: document.adminForm.limitstart.value=$page; document.adminForm.submit();\">$i</a>";
				}//end if
			}//end for

			if ($this_page < $total_pages) 
			{
				$page = $this_page * $this->limit;
				$end_page = ($total_pages-1) * $this->limit;
				echo "\n <a href=\"#next\" class=\"pagenav\" title=\"".PAGE_NEXT."\" onclick=\"JavaScript: document.adminForm.limitstart.value=$page; document.adminForm.submit();\">".PAGE_NEXT."</a> &raquo;";
				echo "\n <a href=\"#end\" class=\"pagenav\" title=\"".PAGE_END."\" onclick=\"JavaScript: document.adminForm.limitstart.value=$end_page; document.adminForm.submit();\">".PAGE_END."</a> &raquo;&raquo;";
			}else{
				echo "\n ".PAGE_NEXT." &raquo;";
				echo "\n ".PAGE_END." &raquo;&raquo;";
			}//end if
		}//end function

		function icon_up($i, $condition=true, $action='orderup', $alt=MOVE_UP)
		{
			if (($i > 0 || ($i+$this->limitstart > 0)) && $condition) 
			{
				return '<a href="#reorder" onClick="return list_items_task(\'adminForm\', \'cb'.$i.'\', \''.$action.'\')" title="'.$alt.'"><img src="./images/icon_up.gif" width="10" height="6" align="absmiddle" alt="'.$alt.'" border="0" /></a>';
  			}else{
  				return '&nbsp;';
			}//end if
		}//end function

		function icon_down( $i, $n, $condition=true, $action='orderdown', $alt=MOVE_DOWN)
		{
			if (($i < $n-1 || $i+$this->limitstart < $this->total-1) && $condition) 
			{
				return '<a href="#reorder" onClick="return list_items_task(\'adminForm\', \'cb'.$i.'\', \''.$action.'\')" title="'.$alt.'"><img src="./images/icon_down.gif" width="10" height="6" align="absmiddle" alt="'.$alt.'" border="0" /></a>';
  			}else{
  				return '&nbsp;';
			}//end if
		}//end function
	}//end class
?>