<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/classes/customers.php 
	# Description: The members class is meant to simplify the task of module members.
	# Write by: Le Hung
	# Start time: May 09, 2008
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class request_form extends access_database
	{
		var $id = null;
		var $group_id = null;
		var $customer = null;
		var $customer_id = null;
		var $move = null;
		var $term_of_payment  = null;
		var $moving_from = null;
		var $moving_to= null;
		var $current_address  = null;
		var $delivery_address= null;
		var $expected_delivery_date= null;
		var $time_of_delivery= null;
		var $other_infomatio= null;
		var $replied = null; 
		var $email_forward = null;
		
		function request_form(&$db) 
		{
			$this->access_database( '`#__request.form`', 'id', $db);
		}//end function
		
		
	}//end class
	
	class form_inbound extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $move = null;
		var $term_of_payment = null;
		var $allowance = null;
		var $allowance_value = null; 
		var $moving_from = null;
		var $moving_to = null;
		var $current_address = null;
		var $delivery_address = null;
		var $expected_delivery_date = null;
		var $time_of_delivery = null;
		var $other_infomation = null;
		var $email_forward = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $forward_date = null; 
		
		function form_inbound(&$db) 
		{
			$this->access_database( '`#__form_inbound`', 'id', $db);
		}//end function
	}//end class

	class form_outbound extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $move = null;
		var $term_of_payment = null;
		var $moving_from = null;
		var $moving_to = null;
		var $current_address = null;
		var $destination_address = null;
		var $expected_survey_date = null;
		var $time_of_survey = null;
		var $expected_moving_date = null;
		var $allowance = null;
		var $allowance_value = null;
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_outbound(&$db) 
		{
			$this->access_database( '`#__form_outbound`', 'id', $db);
		}//end function
	}//end class
	
	class form_national_move extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $term_of_payment = null;
		var $current_address = null;
		var $delivery_address = null;
		var $expected_survey_date = null;
		var $time_of_survey = null;
		var $expected_moving_date = null;
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_national_move(&$db) 
		{
			$this->access_database( '`#__form_national_move`', 'id', $db);
		}//end function
	}//end class
	
	class form_office_move extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $term_of_payment = null;
		var $current_address = null;
		var $delivery_address = null;
		var $expected_survey_date = null;
		var $time_of_survey = null;
		var $expected_moving_date = null;
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_office_move(&$db) 
		{
			$this->access_database( '`#__form_office_move`', 'id', $db);
		}//end function
	}//end class
	
	class form_pet_relocation extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $name = null;
		var $age = null;
		var $breed = null;
		var $weight = null;
		var $vaccination = null;
		var $country_of_origin = null;
		var $country_of_destination = null;
		var $travel_plan = null;
		var $other_infomation = null;
		var $date_of_travel = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_pet_relocation(&$db) 
		{
			$this->access_database( '`#__form_pet_relocation`', 'id', $db);
		}//end function
	}//end class
	
	class form_orientation extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $current_residence = null;
		var $schedule_of_travel_to_vietnam = null;
		var $first_visit_to_vietnam = null;
		var $date_of_last_visit = null; 
		var $children = null; 
		var $city_orientation_package = null;
		var $settling_in_package = null;
		var $servive_home_search=null;
		var $servive_schooling=null;
		var $servive_culture=null;
		var $servive_cleaning=null;
		var $servive_handyman=null;
		var $servive_maid=null;
		var $servive_banking=null;
		var $servive_internet=null;
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_orientation(&$db) 
		{
			$this->access_database( '`#__form_orientation`', 'id', $db);
		}//end function
	}//end class
	
	
	class form_home_search extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $property = null;
		var $property_other = null;
		var $furniture = null; 
		var $furniture_other = null; 
		var $bedroom = null; 
		var $bedroom_other = null; 
		var $monthly_budget = null;
		var $monthly_budget_other = null;
		var $terms_of_lease = null;
		var $terms_of_lease_other = null;
		var $info1 = null;
		var $info2 = null;
		var $info3 = null;
		var $expect_move_in_date = null; 
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;

		function form_home_search(&$db) 
		{
			$this->access_database( '`#__form_home_search`', 'id', $db);
		}//end function
	}//end class

	class homes
	{
		var $_db = null;
		var $_default = null;
		var $_language_id = null;
		var $_html = null;

		function homes(&$db, $default, $language_id) 
		{
			$this->_db=&$db;
			$this->_default=$default;
			$this->_language_id=$language_id;
		}//end function	

		function draw_type($selected='', $attribs='', $str=SELECT_TYPE)
		{
			global $default;

			$this->_html ='';
			if ($this->_default['id']==$this->_language_id) 
			{
				$this->_db->set_query("SELECT `id`, `type` FROM `#__type` WHERE `active`=1 ORDER BY `ordering` ASC");
			}else{ 
				$this->_db->set_query("SELECT t.`id`, tc.`type`  FROM `#__type_convert` tc RIGHT JOIN `#__type` t ON t.`id`=tc.`type_id` AND tc.`language_id`=".$this->_language_id." ORDER BY t.`ordering` ASC");
			}//end if
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				$this->_html.='<select name="type_id" '.$attribs.'>';
				$this->_html.='<option value="">'.$str.'</option>';
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel_0 = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
					
					$this->_html.= '<option value='.$rows[$i]['id'].$sel_0.'>'.$rows[$i]['type'].'</option>';
				}//end for
				$this->_html.='</select>';
			}else{
				$this->_html.='<select name="disable" disabled="disabled" class="selectbox" style="width:160px">';
				$this->_html.='<option value="">'.$str.'</option>';
				$this->_html.='</select>';
			}//end if
			return $this->_html;
		}//enf function

		function show($city_id='', $district_id='', $type_id='', $limitstart, $limit, $url='')
		{	
			$where = array();
			if ($this->_default['id']==$this->_language_id)
			{
				$select='h.*';
				$from='`#__homes` h';
				$innerjoin='';
			}else{
				$select='h.*, hc.`field_name1`, hc.`field_value1`, hc.`field_name2`, hc.`field_value2`, hc.`field_name3`, hc.`field_value3`, hc.`field_name4`, hc.`field_value4`, hc.`other_info`, hc.`address_code`, hc.`landlord`, hc.`address_contact`';
				$from='`#__homes_convert` hc';
				$innerjoin='RIGHT JOIN `#__homes` h ON h.`id`=hc.`home_id` AND hc.`language_id`='.$this->_language_id;
			}//end if
			$where[]='h.`active`=1';
			if ($city_id) $where[]='h.`city_id`='.$city_id;
			if ($district_id) $where[]='h.`district_id`='.$district_id;
			if ($type_id) $where[]='h.`type_id`='.$type_id;
			
			$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
					 . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
			$this->_db->set_query($sql_total);
			$total=$this->_db->load_result();

			include_once(DIR_FS_CLASSES."pages.php");
			$_pav = new pages($total, $limitstart, $limit);
			$leafs_counter=$_pav->leafs_counter();
			$this->_link=$url;
			$page_links=$_pav->pages_links($this->_link);

			$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				   . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				   . "\n ORDER BY h.`modify_date` ASC, h.`create_date` ASC"
				   . "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
			$this->_db->set_query($sql_sel);
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();
			if (!$rows) return false;
			foreach ($rows as $k=>$v)
			{
				if ($this->_default['id']==$this->_language_id)
				{
					$this->_db->set_query('SELECT `type` FROM `#__type` WHERE `id`='.$v['type_id']);
					$rows[$k]['type']=$this->_db->load_result();
				}else{
					$this->_db->set_query('SELECT tc.`type` FROM `#__type_convert` tc RIGHT JOIN `#__type` t ON t.`id`=tc.`type_id` AND tc.`language_id`='.$this->_language_id.' WHERE t.`id`='.$v['type_id']);
					//echo $this->_db->get_query();
					$rows[$k]['type']=$this->_db->load_result();
				}//end if

				if ($this->_default['id']==$this->_language_id)
				{
					$this->_db->set_query('SELECT `name` FROM `#__city` WHERE `id`='.$v['city_id']);
					$rows[$k]['city']=$this->_db->load_result();
				}else{
					$this->_db->set_query('SELECT cc.`name` FROM `#__city_convert` cc RIGHT JOIN `#__city` c ON c.`id`=cc.`name_id` AND cc.`language_id`='.$this->_language_id.' WHERE c.`id`='.$v['city_id']);
					$rows[$k]['city']=$this->_db->load_result();
				}//end if

				if ($this->_default['id']==$this->_language_id)
				{
					$this->_db->set_query('SELECT `name` FROM `#__city` WHERE `id`='.$v['district_id']);
					$rows[$k]['district']=$this->_db->load_result();
				}else{
					$this->_db->set_query('SELECT cc.`name` FROM `#__city_convert` cc RIGHT JOIN `#__city` c ON c.`id`=cc.`name_id` AND cc.`language_id`='.$this->_language_id.' WHERE c.`id`='.$v['district_id']);
					$rows[$k]['district']=$this->_db->load_result();
				}//end if
			}//end foreach
			return array("rows"=>$rows, "leafs_counter"=>$leafs_counter, "page_links"=>$page_links);
		}//end function

		function detail($id)
		{
			if ($this->_default['id']==$this->_language_id)
			{
				$this->_db->set_query('SELECT * FROM `#__homes` WHERE `id`='.$id);
			}else{
				$this->_db->set_query('SELECT h.*, hc.`field_name1`, hc.`field_value1`, hc.`field_name2`, hc.`field_value2`, hc.`field_name3`, hc.`field_value3`, hc.`field_name4`, hc.`field_value4`, hc.`other_info`, hc.`address_code`, hc.`landlord`, hc.`address_contact` FROM `#__homes_convert` hc RIGHT JOIN `#__homes` h ON h.`id`=hc.`home_id` AND hc.`language_id`='.$this->_language_id.' WHERE h.`id`='.$id);
			}//end if
			$row = $this->_db->load_record();
			if (!$row) return false;
			$this->_db->set_query('SELECT * FROM `#__home_photos` WHERE `home_id`='.$row['id'].' AND `active`=1 ORDER BY `id` DESC LIMIT 0, 7');
			$row['photos']=$this->_db->load_record_list();
			return $row;
		}//end if
	}//end class
	
	
	
	class form_record_storage extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $total_boxes = null;
		var $storage_condition = null;
		var $duration_of_storage = null;
		var $other_infomation = null;
		var $expect_move_in_date = null; 
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_record_storage(&$db) 
		{
			$this->access_database( '`#__form_record_storage`', 'id', $db);
		}//end function
	}//end class
	
	
	class form_warehousing extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $commodity_to_be_stored = null;
		var $volume_of_commodity = null;
		var $duration_of_storage = null;
		var $other_infomation = null;
		var $expect_move_in_date = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_warehousing(&$db) 
		{
			$this->access_database( '`#__form_warehousing`', 'id', $db);
		}//end function
	}//end class
	
	class form_handyman_service extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $service_request = null;
		var $date_of_service = null;
		var $time_of_service = null;
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_handyman_service(&$db) 
		{
			$this->access_database( '`#__form_handyman_service`', 'id', $db);
		}//end function
	}//end class
	class form_insurance_claim extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $declaration_of_insured_items = null;
		var $value_insured = null;
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
		
		function form_insurance_claim(&$db) 
		{
			$this->access_database( '`#__form_insurance_claim`', 'id', $db);
		}//end function
	}//end class
	
	class form_exhibition extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $name_of_exhibition = null;
		var $date_of_exhibition = null;
		var $venue_of_exhibition = null;
		var $organizer = null;
		var $commodity = null; 
		var $volume_cbm=null; 
		var $volume_kg=null; 
		var $other_infomation = null;
		var $title= null; 
		var $reply_content = null; 
		var $replied = null; 
		var $email_forward = null;
	
		function form_exhibition(&$db) 
		{
			$this->access_database( '`#__form_exhibition`', 'id', $db);
		}//end function
	}//end class
	
	class customers_request extends access_database
	{
		var $id = null;
		var $country_id = null;
		var $group_id = null;
		var $customer = null;
		var $company = null;
		var $address = null;
		var $address2 = null;
		var $vat = null;
		var $tel_work = null;
		var $tel_home = null;
		var $mobile = null;
		var $email = null;
		var $request_date = null;
		var $status = null;
		
		function customers_request(&$db) 
		{
			$this->access_database( '`#__customers_request`', 'id', $db);
		}//end function

		function check()
		{	
			$this->_db->set_query("SELECT `id` FROM `#__customers_request` "
									."\nWHERE LOWER(`email`)=LOWER('".$this->email."') AND `group_id`=".$this->group_id);
			$xid = intval($this->_db->load_result());
			if ($xid && $xid != intval($this->id )) 
			{
				$this->_error = sprintf(EMAIL_EXIST, $this->email);
				return false;
			}//end if
			return true;
		}//end function
	}//end class
	
?>