<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/classes/tree.php 
	# Description: The tree class is meant to simplify the task of module use tree.
	# Write by: Le Hung
	# Start time: October 26, 2007
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class tree
	{
		var $_db		    = null;			//The database connection
		var $_language_id   = null;
		var $_table		    = null;
		var $_table_convert = null;
		var $_field		    = null;
		var $_convert_id    = null;

		function tree(&$db, $language_id, $table, $table_convert, $field, $convert_id)
		{
			$this->_db = &$db;
			$this->_language_id = $language_id;
			$this->_table = $table;
			$this->_table_convert = $table_convert;
			$this->_field = $field;
			$this->_convert_id = $convert_id;
		}//end function

		function draw_popup($name, $tree_trunk=false, $selected='', $attribs='', $str=SELECT, $id='', $where='')
		{
			global $sel_superior;
			$sel_superior='<select name="'.$name.'" '.$attribs.'>';
			$sel_superior.='<option value="">'.$str.'</option>';
			$sql_sel='SELECT `id`';
			if ($tree_trunk==true) $sql_sel.=', `parent_id`';
			$sql_sel.=', `'.$this->_field.'` FROM `'.$this->_table.'` WHERE `active`=1';
			if ($tree_trunk==true) $sql_sel.=' AND `parent_id`=0';
			if ($id) $sql_sel.=" AND `id`!=".$id;
			if ($where) $sql_sel.=" ".$where;
			$sql_sel.=" ORDER BY `id` ASC";
			
			$this->_db->set_query($sql_sel);
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel_0 = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
					
					$sel_superior .= '<option value='.$rows[$i]["id"].$sel_0.'>'.$rows[$i]["$this->_field"].'</option>';
					if ($tree_trunk==true) $this->tree_trunk($rows[$i]["id"], 0, $selected, $id, $where);
				}//end for
			}
			$sel_superior.='</select>';
			return $sel_superior;
		}//end function
		
		function draw_popup_request($name, $tree_trunk=false, $selected='', $attribs='', $str=SELECT, $id='', $where='')
		{
			global $sel_superior;
			$sel_superior='<select name="'.$name.'" '.$attribs.'>';
			$sel_superior.='<option value="">'.$str.'</option>';
			$sql_sel='SELECT `id`';
			if ($tree_trunk==true) $sql_sel.=', `parent_id`';
			$sql_sel.=', `'.$this->_field.'` FROM `'.$this->_table.'` WHERE ';
			if ($tree_trunk==true) $sql_sel.=' AND `parent_id`=0';
			if ($id) $sql_sel.=" AND `id`!=".$id;
			if ($where) $sql_sel.=" ".$where;
			$sql_sel.=" ORDER BY `id` ASC";
			
			$this->_db->set_query($sql_sel);
		//	echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel_0 = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
					
					$sel_superior .= '<option value='.$rows[$i]["id"].$sel_0.'>'.$rows[$i]["$this->_field"].'</option>';
					if ($tree_trunk==true) $this->tree_trunk($rows[$i]["id"], 0, $selected, $id, $where);
				}//end for
			}
			$sel_superior.='</select>';
			return $sel_superior;
		}//end function



		function tree_trunk($parent_id, $level, $selected, $id="", $where='')
		{
			global $sel_superior;

			$level+=1;
			$space="";

			for ($j=0; $j<$level; $j++)	$space .= "&nbsp;&nbsp;&nbsp;";

			$sql_sel_sub='SELECT `id`, `parent_id`, `'.$this->_field.'` FROM `'.$this->_table.'` WHERE `active`=1 AND `parent_id`='.$parent_id;
			if ($id) $sql_sel_sub.=" AND `id`!=".$id;
			if ($where) $sql_sel_sub.=" ".$where;
			$sql_sel_sub.=" ORDER BY `id` ASC";
			$this->_db->set_query($sql_sel_sub);
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel = $rows[$i]["id"] == $selected ? ' selected="selected"' : '';
					$sel_superior .= '\n\t<option value='.$rows[$i]["id"].$sel.'>'.$space.' |-&raquo; '.$rows[$i]["$this->_field"].'</option>';
					$this->tree_trunk($rows[$i]["id"], $level, $selected, $id, $where);
				}//end for
			}
		}//end function

		function draw_path($path)
		{
			global $default;
			//echo $path;
			$tree_trunk='';
			if ($path) 
			{
				$id = split('_', $path);
				//print_r($id);
				reset($id);
				$i=0;
				while (list($key, $value) = each($id)) 
				{	
					if ($default["id"]==$this->_language_id)
					{
						$sql_sel = 'SELECT `'.$this->_field.'` FROM `'.$this->_table.'` WHERE `id`='.$value.' ORDER BY `id` ASC';
					}else{
						$sql_sel = 'SELECT `'.$this->_table_convert.'`.`'.$this->_field.'`'
						.' FROM `'.$this->_table_convert.'`'
						.' RIGHT JOIN `'.$this->_table.'` ON `'.$this->_table.'`.`id`=`'.$this->_table_convert.'`.`'.$this->_convert_id.'`'
						.' AND `'.$this->_table_convert.'`.`language_id`='.$this->_language_id
						.' WHERE `'.$this->_table.'`.`id`='.$value
						.' ORDER BY `'.$this->_table.'`.`id` ASC' ;
					}//end if
					$this->_db->set_query($sql_sel);
					//echo $this->_db->get_query();
					$rows=$this->_db->load_record_list();
					if ($rows) 
					{
						foreach ($rows as $row) 
						{
							$i++;
							if ($i==count($id)) $tree_trunk.=$row["$this->_field"];
							else $tree_trunk.=$row["$this->_field"]." -&raquo; ";
						}//end foreach
					}else{
						return false;
					}//end if
				}//end while
			}//end if
			return $tree_trunk;
		}//end function

		function path($id)
		{
			global $path;

			$sql_sel="SELECT `id`, `parent_id` FROM `".$this->_table."` WHERE `id`=".$id." ORDER BY `id` ASC";
			$this->_db->set_query($sql_sel);
			//echo $this->_db->get_query()."<br>";
			$rows=$this->_db->load_record_list();
			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$this->sub_path($rows[$i]["parent_id"]);		
					if ($rows[$i]["parent_id"]) $path.=$rows[$i]["parent_id"]."_";
					//$path.=$rows[$i]["parent_id"]."_";
				}//end for
				$path.=$id;
			}//end if
			$get_path=$path;
			//echo $get_path;
			$path="";
			return $get_path;
		}//end function

		function sub_path($parent_id)
		{
			global $path;
			$sql_sel_sub = "";
			if (!$parent_id) return false;
			$sql_sel_sub = "SELECT `id`, `parent_id`" 
						  ." FROM `".$this->_table."`"
						  ." WHERE `id`=".$parent_id
						  ." ORDER BY `id` ASC";
			$this->_db->set_query($sql_sel_sub);
			$rows=$this->_db->load_record_list();
			//echo $this->_db->get_query()."<br>";
			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$this->sub_path($rows[$i]["parent_id"]);
					if ($rows[$i]["parent_id"]>0) $path.=$rows[$i]["parent_id"]."_";
				}//end for
			}
			return $path;
		}//end function

		function draw_popup_none_tree($name, $selected='', $attribs='', $str=SELECT, $field_sort='create_date', $id='', $sort='DESC')
		{
			global $default;

			$html='<select name="'.$name.'" '.$attribs.'>';
			$html.='<option value="">'.$str.'</option>';
			$sql_sel='SELECT `id`, `'.$this->_field.'` FROM `'.$this->_table.'` WHERE `active`=1';
			if ($id) $sql_sel.=" AND `id`!=".$id;
			$sql_sel.=" ORDER BY `".$field_sort."` ".$sort;
			$this->_db->set_query($sql_sel);
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel_0 = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
					
					$html .= '<option value='.$rows[$i]["id"].$sel_0.'>'.$rows[$i]["$this->_field"].'</option>';
				}//end for
			}
			$html.='</select>';
			return $html;
		}//end function
		
		function draw_popup_one_language($name, $selected='', $attribs='', $str=SELECT, $where='', $prefix=false)
		{
			$html ='';
			$html.='<select name="'.$name.'" '.$attribs.'>';
			if ($prefix==true) $html.='<option value="">'.$str.'</option>';
			$sql_sel='SELECT `id`, `'.$this->_field.'` FROM `'.$this->_table.'` WHERE `active`=1 ';
			if ($where) $sql_sel.=$where;
			$sql_sel.=" ORDER BY `id` ASC";
			
			$this->_db->set_query($sql_sel);
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel_0 = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
					
					$html.= '<option value='.$rows[$i]["id"].$sel_0.'>'.$rows[$i]["$this->_field"].'</option>';
				}//end for
			}
			$html.='</select>';
			return $html;
		}//end function
		
		function items_down($id, $arr=false)
		{
			global $items;

			$this->_db->set_query('SELECT `id`, `parent_id` FROM `'.$this->_table.'` WHERE `parent_id`='.$id.' ORDER BY `id` ASC');
			$rows=$this->_db->load_record_list();
			if ($rows)
			{
				for ($i=0; $i<count($rows); $i++)
				{
					$this->sub_items_down($rows[$i]['id'], $arr);		
					if ($arr==true) $items[]=$rows[$i]['id'];
					else $items.=$rows[$i]['id']."','";
				}//end for
				if ($arr==true) $items[]=$id;
				else $items.=$id;
			}//end if
			$get_items=$items;
			if ($arr==false)$items='';
			return $get_items;
		}//end function
		
		function sub_items_down($parent_id, $arr)
		{
			global $items;
			if ($parent_id) $this->_db->set_query('SELECT `id`, `parent_id` FROM `'.$this->_table.'` WHERE `parent_id`='.$parent_id.' ORDER BY `id` ASC');
			$rows=$this->_db->load_record_list();
			
			if ($rows)
			{
				for ($i=0; $i<count($rows); $i++)
				{
					$this->sub_items_down($rows[$i]['id'], $arr);
					if ($arr==true) $items[]=$rows[$i]['id'];
					else $items.=$rows[$i]['id']."','";
					//$items.=$rows[$i]['id']."','";
				}//end for
			}
			return $items;
		}//end function
	}//end class
?>