<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: classes/upload.php 
	# Description: 
	# Write by: Le Hung
	# Start time: November 17, 2007
	# Last update:  
	*/

	class upload
	{
		var $_source = null;
		var $_dest  = null;
		var $_prefix = null;
		var $_filename = null;
		var $_filesize = null;

		function upload($source, $dest, $prefix, $filename, $filesize='')
		{
			$this->_source = $source;
			$this->_dest = $dest;
			$this->_prefix = $prefix;
			$this->_filename = $filename;
			$this->_filesize = $filesize;
		}//end function

		function image()
		{
			if (!$this->_filename) return false;
		
			$format = array('.jpg', '.jpeg', '.gif', '.png');
			$ext = strrchr($this->_filename, '.');
			if (!in_array(strtolower($ext), $format)) return false;
			return true;
		}//end function

		function movie()
		{
			if (!$this->_filename) return false;
		
			$format = array('.asf', '.wma', '.wmv', '.avi', '.wav', '.mpeg', '.mp3', '.mid');
			$ext = strrchr($this->_filename, '.');
			if (!in_array(strtolower($ext), $format)) return false;
			return true;
		}//end function

		function document()
		{
			if (!$this->_filename) return false;
			
			$format = array('.pdf', '.doc', '.rtf', '.txt', '.xl', '.xls', '.ppt', '.pps', '.zip', '.tar', '.rar');
			$ext = strrchr($this->_filename, '.');
			
			if (!in_array(strtolower($ext), $format)) return false;
			return true;
		}//end function

		function flash()
		{
			if (!$this->_filename) return false;
			
			$format = array('.swf');
			$ext = strrchr($this->_filename, '.');
			
			if (!in_array(strtolower($ext), $format)) return false;
			return true;
		}//end function
		
		function file_size()
		{
			if (!$this->_filename) return false;
			if ($this->_filesize)
			{
				if ($this->_filesize > intval(FILE_LIMIT)) return false;
			}else{
				if ($this->_source["size"] > intval(FILE_LIMIT)) return false;
			}//end if
			return true;
		}//end function

		function clear_space()
		{
			if (!$this->_filename) return false;
			
			$new_str = '';
			$str = explode(" ", $this->_filename);
			for ($i=0, $n=count($str); $i<$n; $i++)
			{
				$new_str.=$str[$i];
			}//end for
			return $new_str;
		}//end function

		function isdir() 
		{
			return @is_dir($this->_dest);
		}//end function

		function copyfile($filename, $folder='') 
		{
			$umask = umask(0113);
			if ($this->_filesize)
			{
				if (!$folder) copy ($this->_source, $this->_dest.'/'.$filename);
				else  copy ($this->_source, $this->_dest.'/'.$folder.'/'.$filename);
			}else{
				if (!$folder) copy ($this->_source['tmp_name'], $this->_dest.'/'.$filename);
				else  copy ($this->_source['tmp_name'], $this->_dest.'/'.$folder.'/'.$filename);
			}//end if
			umask($umask);
		}//end function

		function upload_file() 
		{
			if (!$this->isdir()) return false;

			// Get the filetname of the uploaded file 
			$filename = $this->clear_space();
			$filename = strtolower($this->_prefix.$filename);	
			
			// Copy source file
			if ($this->copyfile($filename)) return false;
			return true;	
		}//end function

		function upload_resize_image($small, $large, $folder, $fix_size=false) 
		{
			if (!$this->isdir()) return false;

			// Get the filetname of the uploaded file 
			$filename = $this->clear_space();
			$filename = strtolower($this->_prefix.$filename);	
	
			// Copy source file
			$this->copyfile($filename, $folder);

			// resize image
			$this->resize_image($this->_dest.'/'.$folder.'/'.$filename, $this->_dest.'/small/'.$filename, $small, "75", $fix_size); 

			$this->resize_image($this->_dest.'/'.$folder.'/'.$filename, $this->_dest.'/large/'.$filename, $large, "75", $fix_size);
			return true;	
		}//end function

		function upload_resize_delete_image($size, $fix_size=true) 
		{
			if (!$this->isdir()) return false;

			// Get the filetname of the uploaded file 
			$filename = $this->clear_space();
			$filename = strtolower($this->_prefix.$filename);	
	
			// Copy source file
			$this->copyfile($filename);

			// resize image
			$this->resize_image($this->_dest.'/'.$filename, $this->_dest.'/'.$filename, $size, "75", $fix_size);
			return true;	
		}//end function

		function resize_image($source, $dest, $new_size, $dest_qual, $fix_size=false)
		{
			$image_type = array( 1 => 'GIF', 
								 2 => 'JPG', 
								 3 => 'PNG', 
								 4 => 'SWF', 
								 5 => 'PSD', 
								 6 => 'BMP', 
								 7 => 'TIFF', 
								 8 => 'TIFF', 
								 9 => 'JPC', 
								10 => 'JP2', 
								11 => 'JPX', 
								12 => 'JB2', 
								13 => 'SWC', 
								14 => 'IFF');
			$image_info = @getimagesize($source);

			if ($image_info == null) return false; //die("ERROR: Source file not found!");
			
			$image_info[2] = $image_type[$image_info[2]];

			// GD can only handle JPG & PNG images
			if (($image_info[2] != 'JPG') && ($image_info[2] != 'PNG')) return false; //die("ERROR: GD can only handle JPG and PNG files!");

			
			$src_width = $image_info[0];
			$src_height = $image_info[1];

			if ($fix_size==true) $ratio = $src_width / $new_size;
			else $ratio = max($src_width, $src_height) / $new_size;
			$ratio = max($ratio, 1.0);
			$dest_width = (int)($src_width / $ratio);
			$dest_height = (int)($src_height / $ratio);

			if (!function_exists('imagecreatefromjpeg')) return false; //die('GD image library not installed!');
			
			if ($image_info[2] == 'JPG') $src_img = imagecreatefromjpeg($source);
			else if ($image_info[2] == 'JNG') $src_img = imagecreatefrompng($source);
			else $src_img = imagecreatefromgif($source);

			if (!$src_img) return false;
			
			$dst_img = imagecreatetruecolor($dest_width, $dest_height);
			imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $dest_width, (int)$dest_height, $src_width, $src_height);
			imagejpeg($dst_img, $dest, $dest_qual);
			imagedestroy($src_img);
			imagedestroy($dst_img);
		}//end function
	}//end class
?>