<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/contents.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: October 08, 2007
	# Last update: December 03, 2007 
	*/

	include_once("./logged.php");
	require_once("./classes/tree.php");
	require_once("./classes/contents.php");
	require_once("../languages/".$_SESSION['folder']."/contents.php");
	require_once("./dynamic.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$content_id = intval(get_param($_REQUEST, 'content_id', 0));

	header_page(MN_FEATURE_AREAS, MN_CONTENTS." :: ".MN_DYNAMIC);
	include_once ("./includes/editor/editor.php");

	$error=null;
	if (($action=='editconvert') && (!$id[0]))
	{
	 	$action='';
		$error= CONVERT_ERROR;
	}//end if

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
				modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;

		case "convert":
			if (!$content_id) $content_id=$id[0];
			convert($db, $content_id, 0);
			break;

		case "editconvert":
			convert($db, $content_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		default:
			show($db, $language_id, $error);
			break;
	}//end switch

	function show(&$db, $language_id, $error)
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='cc.*, c.`id` AS `id_default`, c.`title` AS `title_default`, c.`content` AS `content_default`, c.`create_by`, c.`modify_by`, c.`create_date`, c.`modify_date`, c.`active`';
			$from='`#__contents_convert` cc';
			$innerjoin='RIGHT JOIN `#__contents` c ON c.`id`=cc.`content_id` AND cc.`language_id`='.$language_id;
			$sort='cc';
			if ($search) $where[] = 'LOWER(cc.`title`) LIKE "%'.$search.'%" OR LOWER(cc.`content`) LIKE "%'.$search.'%"';
		}else{
			$select='c.*';
			$from='`#__contents` c';
			$innerjoin='';
			$sort='c';
			if ($search) $where[] = 'LOWER(c.`title`) LIKE "%'.$search.'%" OR LOWER(c.`content`) LIKE "%'.$search.'%"';
		}//end if

		$where[]="c.`static`=0";

		$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$sort.".".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_contents::show($language_id, $rows, $search, $_pav, $error);
	}//end function

	function modify(&$db, $id)
	{
		$editor=new wysiwygPro();

		$row = new contents($db);
		if ($id)
		{
			$row->load($id);
		}//end if
			
		html_contents::modify($row, $editor, $error);
	}//end function

	function convert(&$db, $content_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$content_default=content_default($db, $content_id);
		//echo '<pre>';print_r($content_default);echo '</pre>';
		$language_second = $ln->language_second();
		$selected=$language_second["id"].'#'.$language_second["icon"];
		$flag=$language_second["icon"];
		$row = new contents_convert($db);
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$content_default=content_default($db, $row->content_id);
		}//end if
			
		html_contents::convert($content_default, $selected, $flag, $row, $editor, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new contents($db);
		$row->publish_array($cid, $publish);
		/*if (count($cid))
		{
			$cids=implode("','",$cid);
			$db->set_query("UPDATE `#__contents` SET `active`='".$publish."' WHERE `id` IN ('".$cids."')");
			if(!$db->query())
			{
				$error=$db->stderr();
			}//end if
		}//end if*/
			
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=dynamic');
		redirect('./cpanel.php?module=dynamic&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id;
		$editor = new wysiwygPro();
		$error=false;
		if ($default["id"]==$language_id)
		{
			$row=new contents($db);
			$modify_date = date("Y-m-d H:m:s");
			if (!$_POST["id"]) 
			{
				$_POST["create_by"] = $_SESSION["member_id"];
				$_POST["create_date"]=$modify_date;
			}else{ 
				$_POST["modify_by"] = $_SESSION["member_id"];
				$_POST["modify_date"]=$modify_date;
			}//end if
		}else{
			$row = new contents_convert($db);
			$_POST["language_id"] = $language_id;
		}//end if
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			if ($default["id"]==$language_id)
			{
				html_contents::modify($row, $editor, $error);
			}else{
				$content_default=content_default($db, $row->content_id);
				//$selected=$row->id.'#'.$ln->flag_icon($language_id);
				$selected=$language_id.'#'.$ln->flag_icon($language_id);
				$flag=$ln->flag_icon($language_id);
					
				html_contents::convert($content_default, $selected, $flag, $row, $editor, $error);
			}//end if
		}else{
			$goto = trim(strtolower(get_param( $_POST, 'goto', '' )));
			switch ($goto)
			{
				case 'convert':
					redirect('./cpanel.php?module=dynamic&action=convert&content_id='.$row->id);
					break;
				
				case 'addmore':
					redirect('./cpanel.php?module=dynamic&action=new');
					break;
				
				default:
					if ($default["id"] == $language_id) redirect('./cpanel.php?module=dynamic');
					redirect('./cpanel.php?module=dynamic&show='.$row->language_id);	
					break;
			}//end switch
		}//end if
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default;
		
		$row=($default["id"]==$language_id)?new contents($db):new contents_convert($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0;$i<count($cid);$i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					if ($default["id"]==$language_id)
					{
						$sql_del="DELETE FROM `#__contents_convert` WHERE `content_id`=".$cid[$i];
						$db->set_query($sql_del);
						$db->query();
					}//end if
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		if ($default["id"]==$language_id) redirect('./cpanel.php?module=dynamic');
		redirect('./cpanel.php?module=dynamic&show='.$language_id);
	}//end function

	function content_default(&$db, $id)
	{
		if (!$id) return false;
		$row = new contents($db);
		$row->load($id);
		return $row;
	}//end function

	footer_page();
?>