<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/groups.member.php 
	# Description: This file's the access to module group of members.
	# Write by: Le Hung
	# Start time: November 06, 2007
	# Last update:  
	*/

	include_once("./logged.php");
	require_once("./classes/members.php");
	require_once("../languages/".$_SESSION['folder']."/members.php");
	require_once("./groups.member.html.php");
	$no_convert = true;

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));

	header_page(MN_FEATURE_AREAS, MN_MEMBERS.' :: '.MN_GROUP);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
				modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$where = array();

		if ($search) 
		{
			$where[] = '(LOWER(`group`) LIKE "%'.$search.'%" OR LOWER(`note`) LIKE "%'.$search.'%")';
		}//end if

		$sql_total=("SELECT count(*) AS num FROM `#__groups_member` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__groups_member` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_group::show($rows, $search, $_pav, $error);
	}//end function

	function modify(&$db, $id)
	{
		$row = new groups_member($db);
		if ($id)
		{
			$row->load($id);
		}//end if
			
		html_group::modify($row, $error);
	}//end function

	function publish(&$db, $cid=null, $publish=1)
	{
		if (count($cid))
		{
			$row = new groups_member($db);
			$error=array();
			if (in_array(1, $cid))
			{
				$row->_error=sprintf(CANNOT_PUBLISH_GROUP_ADMIN, GROUP_ID.' 1', GROUP_ID.' 1');
				$error=$row->get_error();
			}else{
				/*$cids=implode("','",$cid);
				$db->set_query("UPDATE `#__groups_member` SET `active`='".$publish."' WHERE `id` IN ('".$cids."')");
				if(!$db->query())
				{
					$error=$db->stderr();
				}//end if*/
				$row->publish_array($cid, $publish);
			}//end if
		}//end if
			
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=groups.member');
	}//end function

	function save(&$db)
	{	
		$error=false;
	
		$row=new groups_member($db);
		$modify_date = date("Y-m-d H:m:s");
		if (!$_POST["id"]) 
		{
			$_POST["create_by"] = $_SESSION["member_id"];
			$_POST["create_date"]=$modify_date;
		}else{ 
			$_POST["modify_by"] = $_SESSION["member_id"];
			$_POST["modify_date"]=$modify_date;
		}//end if
	
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			html_group::modify($row, $error);
		}else{
			redirect('./cpanel.php?module=groups.member');
		}//end if
	}//end function

	function remove(&$db, $cid)
	{	
		$row = new groups_member($db);
		$error=array();

		if (count($cid))
		{	
			if (in_array(1, $cid))
			{
				$row->_error=sprintf(CANNOT_DELETE_GROUP_ADMIN, GROUP_ID.' 1', GROUP_ID.' 1');
				$error=$row->get_error();
			}else{
				$joins[]=array('label'=>GROUP_ID, 'name'=>'`#__members`', 'idfield'=>'id', 'joinfield'=>'`group_id`');

				for ($i=0; $i<count($cid); $i++)
				{
					if (!$row->can_delete($cid[$i], $joins))
					{
						$error[]=$row->get_error();
					}else{
						$row->delete_record($cid[$i]);
					}//end if
				}//end for
			}//end if
		}//end if
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=groups.member');
	}//end function

	footer_page();
?>