<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/inbound.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/inbound.php");
	require_once("./classes/customers.php");
	require_once("./classes/tree.php");
	require_once("../languages/".$_SESSION['folder']."/customers.php");
	require_once("../languages/".$_SESSION['folder']."/inbound.php");
	require_once("./inbound.html.php");
	require_once("./move_management.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$box_location = new tree($db, $language_id, '#__locations', '', 'name', '');
	$no_convert = true;
	$no_add_item = true;

	header_page(MN_TRACKING_AREAS, MN_MOVE_MANAGEMENT.' :: '.MN_INBOUND);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		//case "new":
		//		modify($db, 0);
		//	break;
		
		case "edit":
			modify($db, $id[0], $customer_id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', 'c.`customer`')));
		if (!$field_sort) $field_sort="c.`customer`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$customer = trim(strtolower(get_param( $_POST, 'customer', '' )));
		$company = trim(strtolower(get_param( $_POST, 'company', '' )));
		
		$from_date = trim(strtolower(get_param( $_POST, 'from_date', '' )));
		$to_date = trim(strtolower(get_param( $_POST, 'to_date', '' )));

		$country_id=intval(get_param($_POST, 'country_id', 0));

		$insurance = trim(strtolower(get_param( $_POST, 'insurance', '' )));
		$mode = trim(strtolower(get_param( $_POST, 'mode', '' )));
		$service = trim(strtolower(get_param( $_POST, 'service', '' )));
		$air = intval(get_param( $_POST, 'air', 0 ));
		$oa = trim(strtolower(get_param( $_POST, 'oa', '' )));
		$ba = trim(strtolower(get_param( $_POST, 'ba', '' )));
		$status = trim(strtolower(get_param( $_POST, 'status', '' )));

		$where = array();

		if ($search) 
		{
			//$where[] = '((LOWER(o.`from`) LIKE "%'.$search.'%") OR (LOWER(o.`to`) LIKE "%'.$search.'%") OR (LOWER(o.`delivery_address`) LIKE "%'.$search.'%") OR (o.`survey_date` = db_date('.$search.')) OR (o.`packing_date` = db_date('.$search.')) OR (LOWER(o.`quote_ref`) LIKE "%'.$search.'%") OR (o.`quote_ref_date` = db_date('.$search.')))';
			$where[] = '((LOWER(m.`from`) LIKE "%'.$search.'%") OR (LOWER(m.`to`) LIKE "%'.$search.'%") OR (LOWER(c.`username`) LIKE "%'.$search.'%" OR LOWER(c.`email`) LIKE "%'.$search.'%" OR LOWER(c.`customer`) LIKE "%'.$search.'%" OR LOWER(c.`company`) LIKE "%'.$search.'%" OR LOWER(c.`address`) LIKE "%'.$search.'%" OR LOWER(c.`address2`) LIKE "%'.$search.'%" OR LOWER(c.`tel_work`) LIKE "%'.$search.'%" OR LOWER(c.`tel_home`) LIKE "%'.$search.'%" OR LOWER(c.`mobile`) LIKE "%'.$search.'%" OR LOWER(c.`note`) LIKE "%'.$search.'%"))';
		}//end if
		
		if ($customer) $where[] = 'c.`customer` like "%'.$customer.'%"';
		if ($company) $where[] = 'c.`company` like "%'.$company.'%"';
		
		if ($from_date) $where[] = '"'.db_date($from_date).'" <= m.`input_date`';
		if ($to_date) $where[] = '"'.db_date($to_date) .'" >= m.`input_date`';

		if ($country_id) $where[] = 'c.`country_id`='.$country_id;
		if ($insurance) $where[] = 'm.`insurance`='.$insurance;
		if ($mode)
		{
			if ($mode=='other') $where[] = ('LOWER(m.`mode`)!="surface" AND LOWER(m.`mode`)!="air" AND LOWER(m.`mode`)!="road"');
			else $where[] = ('LOWER(m.`mode`)="'.$mode.'"');
		}//end fi
		if ($service) $where[] = 'LOWER(m.`service`)="'.$service.'"';
		if ($air) $where[] = 'm.`air`='.$air;
		if ($oa) $where[] = $oa.'=1';
		if ($ba) $where[] = $ba.'=1';
		if ($status=='all'){
			 $where[] = ' m.`online`=1';
			 $where[] = ' m.`done`=1';
			 $where[] = ' m.`closed`=1';
		}	 
		elseif($status == 'm.`done`') {
			$where[] = ' m.`done`=1';
			$where[] = ' m.`closed`=0';
		}elseif($status == 'm.`closed`') {
			$where[] = ' m.`done`=0';
			$where[] = ' m.`closed`=1';
		}elseif($status == 'm.`online`') {
			$where[] = ' m.`done`=0';
			$where[] = ' m.`closed`=0';
		}	
		
		//echo $status;

		$where[]='c.`active`=1';
		$where[]='c.`move_in`=1';
		
		$sql_total=("SELECT count(*) AS num FROM `#__inbound` m RIGHT JOIN `#__customers` c ON m.`customer_id`=c.`id`"
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT m.*, c.`id` AS customer_id, c.`customer`, c.`country_id`, c.`company`, c.`address`, c.`address2`, c.`vat`, c.`tel_work`, c.`tel_home`, c.`mobile`, c.`email`, c.`username` FROM `#__inbound` m RIGHT JOIN `#__customers` c ON m.`customer_id`=c.`id`"
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		//echo '<pre>';print_r($rows);echo '</pre>';
		//echo $mode;
		
		html_inbound::show($rows, $search, $_pav, $customer, $company, $from_date, $to_date, $country_id, $mode, $service, $air, $insurance, $oa, $ba, $status, $error);
	}//end function

	function modify(&$db, $id, $customer_id)
	{
		$row = new inbound($db);
		if ($id)
		{
			$row->load($id);
		}else{
			$row->bind($_POST, '');
		}//end if

		//echo '<pre>';print_r($row);echo '</pre>';

		$customer_info=customer_info($db, $customer_id);
		
		html_inbound::modify($row, $customer_info, $error);
	}//end function

	function publish(&$db, $cid=null, $publish=1)
	{
		$row = new inbound($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=inbound');
	}//end function

	function save(&$db)
	{
		$row=new inbound($db);
			
		$error=false;
		$ignore=null;

		$modify_date = date("Y-m-d H:m:s");		
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check())$error=$row->get_error();

		if (isset($_POST['mode']))
			if($_POST['mode']==1)  $row->mode=$_POST['mode_other']; 
		if ($_POST['pre_advice_date_from_oa']) $row->pre_advice_date_from_oa=db_date($_POST['pre_advice_date_from_oa']);
		if ($_POST['doc_received_date_from_client']) $row->doc_received_date_from_client=db_date($_POST['doc_received_date_from_client']);
		if ($_POST['doc_received_date_from_agent']) $row->doc_received_date_from_agent=db_date($_POST['doc_received_date_from_agent']);
		
		if ($_POST['quote_ref_date']) $row->quote_ref_date=db_date($_POST['quote_ref_date']);
		
		if(isset($_POST['air'])){
			if ($_POST['air']=='0')
			{
				$row->air_weight = '';
				$row->air_chargeble = '';
				$row->air_no_of_package = '';
				$row->air_in = '';
				$row->air_awb_no = '';
				$row->air_flight_no = '';
				$row->air_aod = '';
				$row->air_aoe = '';
				$row->air_etd = '';
				$row->air_eta = '';
				$row->air_note = '';
				
				$row->road_volume = '';
				$row->road_volume_lcl_fcl = '';
				$row->road_weight = '';
				$row->road_no_of_package = '';
				$row->road_vessel_no = '';
				$row->road_container_no = '';
				$row->road_seal_no = '';
				$row->road_bl_no = '';
				$row->road_pod = '';
				$row->road_poe = '';
				$row->road_etd = '';
				$row->road_eta = '';
				$row->road_note = '';
				
				$row->other_volume = '';
				$row->other_volume_lcl_fcl = '';
				$row->other_weight = '';
				$row->other_no_of_package = '';
				$row->other_vessel_no = '';
				$row->other_container_no = '';
				$row->other_seal_no = '';
				$row->other_bl_no = '';
				$row->other_pod = '';
				$row->other_poe = '';
				$row->other_etd = '';
				$row->other_eta = '';
				$row->other_note = '';
				
				$row->sea_eta=db_date($_POST['sea_eta']);
				$row->sea_etd=db_date($_POST['sea_etd']);
				if ($_POST['sea_volume']) $row->sea_volume=$_POST['sea_volume'];
				if ($_POST['sea_weight']) $row->sea_weight=$_POST['sea_weight'];
			}elseif($_POST['air']=='1'){
				$row->sea_volume = '';
				$row->sea_volume_lcl_fcl = '';
				$row->sea_weight = '';
				$row->sea_no_of_package = '';
				$row->sea_vessel_no = '';
				$row->sea_container_no = '';
				$row->sea_seal_no = '';
				$row->sea_bl_no = '';
				$row->sea_pod = '';
				$row->sea_poe = '';
				$row->sea_etd = '';
				$row->sea_eta = '';
				$row->sea_note = '';
				
				$row->road_volume = '';
				$row->road_volume_lcl_fcl = '';
				$row->road_weight = '';
				$row->road_no_of_package = '';
				$row->road_vessel_no = '';
				$row->road_container_no = '';
				$row->road_seal_no = '';
				$row->road_bl_no = '';
				$row->road_pod = '';
				$row->road_poe = '';
				$row->road_etd = '';
				$row->road_eta = '';
				$row->road_note = '';
				
				$row->other_volume = '';
				$row->other_volume_lcl_fcl = '';
				$row->other_weight = '';
				$row->other_no_of_package = '';
				$row->other_vessel_no = '';
				$row->other_container_no = '';
				$row->other_seal_no = '';
				$row->other_bl_no = '';
				$row->other_pod = '';
				$row->other_poe = '';
				$row->other_etd = '';
				$row->other_eta = '';
				$row->other_note = '';
				
				$row->air_eta=db_date($_POST['air_eta']);
				$row->air_etd=db_date($_POST['air_etd']);
				if ($_POST['air_weight']) $row->air_weight=$_POST['air_weight'];
				if ($_POST['air_chargeble']) $row->air_chargeble=$_POST['air_chargeble'];
				if ($_POST['air_no_of_package']) $row->air_no_of_package=$_POST['air_no_of_package'];
				if ($_POST['air_in']) $row->air_in=$_POST['air_in'];
				//if ($_POST['sea_no_of_package']) $row->sea_no_of_package=db_number($_POST['sea_no_of_package']);
				
			}if ($_POST['air']=='2')
			{
				$row->sea_volume = '';
				$row->sea_volume_lcl_fcl = '';
				$row->sea_weight = '';
				$row->sea_no_of_package = '';
				$row->sea_vessel_no = '';
				$row->sea_container_no = '';
				$row->sea_seal_no = '';
				$row->sea_bl_no = '';
				$row->sea_pod = '';
				$row->sea_poe = '';
				$row->sea_etd = '';
				$row->sea_eta = '';
				$row->sea_note = '';
				
				$row->air_weight = '';
				$row->air_chargeble = '';
				$row->air_no_of_package = '';
				$row->air_in = '';
				$row->air_awb_no = '';
				$row->air_flight_no = '';
				$row->air_aod = '';
				$row->air_aoe = '';
				$row->air_etd = '';
				$row->air_eta = '';
				$row->air_note = '';
				
				$row->other_volume = '';
				$row->other_volume_lcl_fcl = '';
				$row->other_weight = '';
				$row->other_no_of_package = '';
				$row->other_vessel_no = '';
				$row->other_container_no = '';
				$row->other_seal_no = '';
				$row->other_bl_no = '';
				$row->other_pod = '';
				$row->other_poe = '';
				$row->other_etd = '';
				$row->other_eta = '';
				$row->other_note = '';
				
				$row->road_eta=db_date($_POST['road_eta']);
				$row->road_etd=db_date($_POST['road_etd']);
				if ($_POST['road_volume']) $row->sea_volume=$_POST['road_volume'];
				if ($_POST['road_weight']) $row->sea_weight=$_POST['road_weight'];
			}if ($_POST['air']=='3')
			{
				$row->sea_volume = '';
				$row->sea_volume_lcl_fcl = '';
				$row->sea_weight = '';
				$row->sea_no_of_package = '';
				$row->sea_vessel_no = '';
				$row->sea_container_no = '';
				$row->sea_seal_no = '';
				$row->sea_bl_no = '';
				$row->sea_pod = '';
				$row->sea_poe = '';
				$row->sea_etd = '';
				$row->sea_eta = '';
				$row->sea_note = '';
				
				$row->air_weight = '';
				$row->air_chargeble = '';
				$row->air_no_of_package = '';
				$row->air_in = '';
				$row->air_awb_no = '';
				$row->air_flight_no = '';
				$row->air_aod = '';
				$row->air_aoe = '';
				$row->air_etd = '';
				$row->air_eta = '';
				$row->air_note = '';
				
				$row->road_volume = '';
				$row->road_volume_lcl_fcl = '';
				$row->road_weight = '';
				$row->road_no_of_package = '';
				$row->road_vessel_no = '';
				$row->road_container_no = '';
				$row->road_seal_no = '';
				$row->road_bl_no = '';
				$row->road_pod = '';
				$row->road_poe = '';
				$row->road_etd = '';
				$row->road_eta = '';
				$row->road_note = '';
				if ($_POST['other_volume']) $row->sea_volume=$_POST['other_volume'];
				if ($_POST['other_weight']) $row->sea_weight=$_POST['other_weight'];
				$row->other_eta=db_date($_POST['other_eta']);
				$row->other_etd=db_date($_POST['other_etd']);
			}
		}	
		if ($_POST['customs_inspection_date']) $row->customs_inspection_date=db_date($_POST['customs_inspection_date']);
		if (isset($_POST['storage'])){
			if ($_POST['storage']=='0')
			{
				$row->duration_from='';
				$row->duration_to='';
			}else{
				if ($_POST['duration_from']) $row->duration_from=db_date($_POST['duration_from']);
				if ($_POST['duration_to']) $row->duration_to=db_date($_POST['duration_to']);
			}//end if
		}
		
		if (isset($_POST['insurance'])){
			if ($_POST['insurance']=='0')
			{
				$row->insurance = '';
				$row->insurance_policy_no = '';
				$row->insurance_date = '';
				$row->insurance_value = '';
				$row->insurance_pair_sets = '';
				$row->insurance_m_e = '';
				$row->insurance_status_damage = '';
				$row->insurance_status_damage_claim_date = '';
				$row->insurance_status_damage_claim_value = '';
				$row->insurance_status_damage_claim_by = '';
				$row->insurance_status_loss = '';
				$row->insurance_status_loss_claim_date = '';
				$row->insurance_status_loss_claim_value = '';
				$row->insurance_status_loss_claim_by = '';
			}elseif($_POST['insurance']=='2'){
				$row->insurance = '2';
				$row->insurance_policy_no = '';
				$row->insurance_date = '';
				$row->insurance_value = '';
				$row->insurance_pair_sets = '';
				$row->insurance_m_e = '';
				$row->insurance_status_damage = '';
				$row->insurance_status_damage_claim_date = '';
				$row->insurance_status_damage_claim_value = '';
				$row->insurance_status_damage_claim_by = '';
				$row->insurance_status_loss = '';
				$row->insurance_status_loss_claim_date = '';
				$row->insurance_status_loss_claim_value = '';
				$row->insurance_status_loss_claim_by = '';
			}else{
				if ($_POST['insurance_date']) $row->insurance_date=db_date($_POST['insurance_date']);
				if (!isset($_POST['insurance_status_damage']) || (!$_POST['insurance_status_damage']))
				{
					$row->insurance_status_damage=0;
					$row->insurance_status_damage_claim_date = '';
					$row->insurance_status_damage_claim_value = '';
					$row->insurance_status_damage_claim_by = '';
				}else{
					$row->insurance_status_damage=1;
					
					if (!isset($_POST['insurance_status_damage_claim_date_checkbox']) || (!$_POST['insurance_status_damage_claim_date_checkbox']))
					{
						$row->insurance_status_damage_claim_date = '';
					}else if ($_POST['insurance_status_damage_claim_date']){ 
						$row->insurance_status_damage_claim_date = db_date($_POST['insurance_status_damage_claim_date']);
					}//end if
	
					if (!isset($_POST['insurance_status_damage_claim_value_checkbox']) || (!$_POST['insurance_status_damage_claim_value_checkbox'])) $row->insurance_status_damage_claim_value = '';
					if (!isset($_POST['insurance_status_damage_claim_by_checkbox']) || (!$_POST['insurance_status_damage_claim_by_checkbox'])) $row->insurance_status_damage_claim_by = '';
				}//end if
	
				
				if (!isset($_POST['insurance_status_loss']) || (!$_POST['insurance_status_loss']))
				{
					$row->insurance_status_loss=0;
					$row->insurance_status_loss_claim_date = '';
					$row->insurance_status_loss_claim_value = '';
					$row->insurance_status_loss_claim_by = '';
				}else{
					$row->insurance_status_loss=1;
					if (!isset($_POST['insurance_status_loss_claim_date_checkbox']) || (!$_POST['insurance_status_loss_claim_date_checkbox'])) 
					{
						$row->insurance_status_loss_claim_date = '';
					}else if ($_POST['insurance_status_loss_claim_date']){
						$row->insurance_status_loss_claim_date=db_date($_POST['insurance_status_loss_claim_date']);
					}//end if
	
					if (!isset($_POST['insurance_status_loss_claim_value_checkbox']) || (!$_POST['insurance_status_loss_claim_value_checkbox'])) $row->insurance_status_loss_claim_value = '';
					if (!isset($_POST['insurance_status_loss_claim_by_checkbox']) || (!$_POST['insurance_status_loss_claim_by_checkbox'])) $row->insurance_status_loss_claim_by = '';
				}//end if
	
				if ($_POST['insurance_value']) $row->insurance_value=$_POST['insurance_value'];
			}//end if
		}
		
		
		if ($_POST['extra_charge_export_tax']) $row->extra_charge_export_tax=$_POST['extra_charge_export_tax'];
		if ($_POST['extra_charge_cultural_fee']) $row->extra_charge_cultural_fee=$_POST['extra_charge_cultural_fee'];
		if ($_POST['extra_charge_storage']) $row->extra_charge_storage=$_POST['extra_charge_storage'];
		if ($_POST['extra_charge_ws_handling']) $row->extra_charge_ws_handling=$_POST['extra_charge_ws_handling'];
		if ($_POST['extra_charge_value']) $row->extra_charge_value=$_POST['extra_charge_value'];
		if ($_POST['origin_duration_from']) $row->origin_duration_from=db_date($_POST['origin_duration_from']);
		if ($_POST['origin_duration_to']) $row->origin_duration_to=db_date($_POST['origin_duration_to']);
		if ($_POST['destination_duration_from']) $row->destination_duration_from=db_date($_POST['destination_duration_from']);
		if ($_POST['destination_duration_to']) $row->destination_duration_to=db_date($_POST['destination_duration_to']);
		if (!isset($_POST['storage_origin']) || (!$_POST['storage_origin'])) $row->storage_origin=0;
		if (!isset($_POST['storage_destination']) || (!$_POST['storage_destination'])) $row->storage_destination=0;
		if (!isset($_POST['storage_no']) || (!$_POST['storage_no'])) $row->storage_no=0;
		
		if ($_POST['on_board_date']) $row->on_board_date=db_date($_POST['on_board_date']);
		
		if ($_POST['on_board_eta']) $row->on_board_eta=db_date($_POST['on_board_eta']);
		
		if (!$row->storage_origin)
		{
			$row->origin_duration_from='';
			$row->origin_duration_to='';
		}//end if
		
		if (!$row->storage_destination)
		{
			$row->destination_duration_from='';
			$row->destination_duration_to='';
		}//end if
		
		if ($row->storage_no=='1'){
			$row->origin_duration_from='';
			$row->origin_duration_to='';
			$row->destination_duration_from='';
			$row->destination_duration_to='';
			$row->storage_origin='';
			$row->storage_destination='';
		}

		if (!isset($_POST['booking_agent']) || (!$_POST['booking_agent'])) 
		{
			$row->booking_agent=0;
			$row->booking_agent_charge='';
			$row->booking_agent_amount='';
		}//end if

		if (!isset($_POST['destination_agent']) || (!$_POST['destination_agent'])) 
		{
			$row->destination_agent=0;
			$row->destination_agent_charge='';
			$row->destination_agent_amount='';
		}//end if

		if (!isset($_POST['client']) || (!$_POST['client'])) 
		{
			$row->client=0;
			$row->client_charge='';
			$row->client_amount='';
		}//end if

		if (!isset($_POST['client_company']) || (!$_POST['client_company'])) 
		{
			$row->client_company=0;
			$row->client_company_charge='';
			$row->client_company_amount='';
		}//end if

		if (!isset($_POST['oa_fidi']) || (!$_POST['oa_fidi'])) $row->oa_fidi=0;
		if (!isset($_POST['oa_uts']) || (!$_POST['oa_uts'])) $row->oa_uts=0;
		if (!isset($_POST['oa_non']) || (!$_POST['oa_non'])) $row->oa_non=0;

		if (!isset($_POST['ba_fidi']) || (!$_POST['ba_fidi'])) $row->ba_fidi=0;
		if (!isset($_POST['ba_uts']) || (!$_POST['ba_uts'])) $row->ba_uts=0;
		if (!isset($_POST['ba_non']) || (!$_POST['ba_non'])) $row->ba_non=0;
		
		if (!isset($_POST['online']) || (!$_POST['online'])) $row->online=0;
		if (!isset($_POST['done']) || (!$_POST['done'])) $row->done=0;
		if (!isset($_POST['closed']) || (!$_POST['closed'])) $row->closed=0;

		
		if ($_POST['input_date']) $row->input_date=db_date($_POST['input_date']);
		if ($_POST['sea_etd']) $row->sea_etd=db_date($_POST['sea_etd']);
		if ($_POST['sea_eta']) $row->sea_eta=db_date($_POST['sea_eta']);
		if ($_POST['air_etd']) $row->air_etd=db_date($_POST['air_etd']);
		if ($_POST['air_eta']) $row->air_eta=db_date($_POST['air_eta']);
		if ($_POST['expected']) $row->expected=db_date($_POST['expected']);

		$modify_date = date("Y-m-d H:m:s");	
		if (!$row->id)
		{
			$row->create_by = $_SESSION["member_id"];
			$row->create_date=$modify_date;
		}else{
			$row->modify_by = $_SESSION["member_id"];
			$row->modify_date=$modify_date;
		}//end if
		
		if ($_POST['payment_confirmed_by_paid_on']) $row->payment_confirmed_by_paid_on=db_date($_POST['payment_confirmed_by_paid_on']);
		
		if(!$error)
			if (!$row->store())$error=$row->get_error();
		
		if ($error)
		{
			$customer_info=customer_info($db, $row->customer_id);
			html_inbound::modify($row, $customer_info, $error);
		}else{
			redirect("?module=inbound");
		}//end if
	}//end function

	function remove(&$db, $cid)
	{	
		$row = new inbound($db);
		$error=false;

		if (count($cid))
		{
			$joins='';
			for($i=0; $i<count($cid); $i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		
		redirect('./cpanel.php?module=inbound');
	}//end function

	function country(&$db, $id)
	{
		$db->set_query('SELECT `name` FROM `#__locations` WHERE `id`='.$id);
		return $db->load_result();
	}//end function

	function customer_info(&$db, $id)
	{
		if (!$id) return false;
		$row = new customers($db);
		$row->load($id);
		return $row;
	}//end function

	footer_page();
?>