<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/includes/editorconf.php  
	# Description: This file's define the information connecting to 
				   website's hosting support tool editor.
	# ReWrite by: Le Hung
	# Start time: October 22, 2007
	# Last update:  
	*/

	// WP 2.2.8 Configuration file for use with WP Mambot for Mambo 4.5.1 - 4.5.2 and WP 2.2.8
	// You shouldn't need to change anything in this file, except if things aren't working!!
	// This script will work out how to include the global mos configuration, include it and then set WP variables using the mos variables so that user doesn't need to do any configuration!

	// uncomment for easy debug.
	$wpInDialog = true;
	DEFINE ('WP_ABSOLUTE_PATH', preg_replace('/includes([\/\\\]+)editorconf.php/i', '', __FILE__));
	//echo WP_ABSOLUTE_PATH;
	DEFINE ("PATH_PHYSICAL", path_physical(WP_ABSOLUTE_PATH));
	//echo '<br>'.PATH_PHYSICAL;
	DEFINE ('DEFAULT_LANG', "en-us.php");
	DEFINE ('DOMAIN_ADDRESS', strtolower(substr($_SERVER['SERVER_PROTOCOL'],0,strpos($_SERVER['SERVER_PROTOCOL'],'/')) . (isset($_SERVER['HTTPS']) ? ($_SERVER['HTTPS'] == "on" ? 's://' : '://') : '://' ) . $_SERVER['SERVER_NAME'] ) );
	/*DEFINE ('SUB_DIRECTORY', '/saigonvan.com');*/
	DEFINE ('SUB_DIRECTORY', '');
	DEFINE ('WP_FILE_DIRECTORY', './includes/editor/');
	DEFINE ('WP_WEB_DIRECTORY', SUB_DIRECTORY.'/administrator/includes/editor/');
	DEFINE ('IMAGE_FILE_DIRECTORY', PATH_PHYSICAL.'filesmanager/images/');
	DEFINE ('DOCUMENT_FILE_DIRECTORY', PATH_PHYSICAL.'/filesmanager/documents/');
	$trusted_directories = array();
	DEFINE ('SMILEY_FILE_DIRECTORY', null);
	DEFINE ('SMILEY_WEB_DIRECTORY', null);
	DEFINE ('NOCACHE', false);
	DEFINE ('SAVE_LENGTH', 9000);
	define ('SAVE_DIRECTORY', SUB_DIRECTORY.'/administrator/includes/editor/save/');

	//echo IMAGE_FILE_DIRECTORY;



	// -------------------------------------------------------------------------------
	// All of the following variables affect file management in the image and document windows:
	// -------------------------------------------------------------------------------

	//////////////////////////
	// User Permissions
	//////////////////////////

	// We will check for valid mos users and dynamically set the permissions accordingly.
	// Logged in users with a valid mos session will have full file system access, others will not.
	// Note: directory editing is only available from the admin end
	if ($wpInDialog) 
	{	
		// user not logged in anywhere, no permissions (=0).
		if (true) $permissions = 2;
		else $permissions = 0;
	}//end if
	
	// now actually set the permissions
	switch($permissions) 
	{
		case 0 : // no permissions
			$delete_files = false;
			$delete_directories = false;
			$create_directories = false;
			$rename_files = false;
			$rename_directories = false;
			$upload_files = false;
			$overwrite = false;
			break;

		case 1 : // upload only
			$delete_files = false;
			$delete_directories = false;
			$create_directories = true;
			$rename_files = false;
			$rename_directories = false;
			$upload_files = true;
			$overwrite = false;
			break;

		case 2 : // all permissions
			$delete_files = true;
			$delete_directories = true;
			$create_directories = true;
			$rename_files = true;
			$rename_directories = true;
			$upload_files = true;
			$overwrite = true;
			break;
	}//end switch	
	
	
	////////////////////////////
	// File Types  
	////////////////////////////
	
	// These variables decide what types of files users are allowed to upload using the image or document management windows
	
	// What types of images can be uploaded? Separate with a comma.
	$image_types = ".jpg, .jpeg, .gif, .png";
	
	// What types of documents can be uploaded? Separate with a comma.
	$document_types = ".html, .htm, .pdf, .doc, .rtf, .txt, .xl, .xls, .ppt, .pps, .zip, .tar, .swf, .wmv, .rm, .mov, .jpg, .jpeg, .gif, .png";
	
	////////////////////////////
	// File Sizes
	////////////////////////////
	
	// maximum width of uploaded images in pixels set this to ensure that users don't destroy your site's design!!
	$max_image_width = "1200";
	
	// maximum height of uploaded images in pixels set this to ensure that users don't destroy your site's design!!
	$max_image_height = "1000";
	
	// maximum image filesize to upload in bytes
	$max_file_size = "1500000";
	
	// maximum size of documents to upload in bytes
	//$max_documentfile_size = $params->get( 'max_document_size', 2000000 );
	$max_documentfile_size = "2000000";
	
	
	// CHMOD files and folders?
	
	//$file_CHMOD = $params->get( 'FILE_CHMOD_MODE', 0 );
	//$folder_CHMOD = $params->get( 'CHMOD_MODE', 0 );
	$file_CHMOD = 0;
	$folder_CHMOD = 0;

	if (!empty($file_CHMOD)) 
	{
		define('FILE_CHMOD_MODE', $file_CHMOD);
	}//end if

	if (!empty($folder_CHMOD)) 
	{
		define('CHMOD_MODE', $folder_CHMOD);
	}//end if
	

	DEFINE ('IMAGE_WEB_DIRECTORY', SUB_DIRECTORY.'/filesmanager/images/');
	DEFINE ('DOCUMENT_WEB_DIRECTORY', SUB_DIRECTORY.'/filesmanager/documents/');

	// end variables, do not change anything below
	// ----------------------------------------

	DEFINE ('WP_CONFIG', false);

	//global $wp_has_been_previous;
	//$wp_has_been_previous = false;
	//include_once(WP_FILE_DIRECTORY.'/includes/error_reporting.php');
	// ----------------------------------------
	

	//write by hungbui
	function path_physical($path)
	{
		$script_filename = str_replace('\\', '/', $path);
		$script_filename = str_replace('//', '/', $script_filename);

		$dir_fs_www_root_array = explode('/', dirname($script_filename));
		$dir_fs_www_root = array();
		for ($i=0, $n=sizeof($dir_fs_www_root_array); $i<$n; $i++) 
		{
			$dir_fs_www_root[] = $dir_fs_www_root_array[$i];
		}//end for
		$dir_fs_www_root = implode('/', $dir_fs_www_root) . '/';
		return $dir_fs_www_root;
	}//end function
?>