<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : administrator/index.php
	# Description: This is the main page of a signin to control the website. 
				   Here users will be able to signin. However, like on most sites 
				   the login form doesn't just have to be on the main page, 
				   but re-appear on subsequent pages, depending on whether 
				   the user has logged in or not.
	# Write by: Le Hung
	# Start time: Semptember 17, 2007
	# Last update: September 24, 2007
	*/

	require_once("./includes/common.php");
	require_once("./classes/online.php");
	require_once("../languages/index.php");
	require_once("./includes/define.php");
	require_once("./classes/signin.php");

	
	//session_destroy();
	$online = new online($db);
	$online->check_denied();
	//echo "<br>".$online->logged;
	//exit();
	if ($online->logged) redirect("./cpanel.php");

	$action = trim(strtolower(get_param($_POST, 'action', '')));
	$remember = intval(get_param($_POST, 'remember', 0));
	$language = trim(strtolower(get_param($_POST, 'language', $default["id"]."#".$default["icon"])));
	$login_failed=false;

	if (!isset($_SESSION["failed_num"])) $_SESSION["failed_num"] = 0;
	if (isset($_SESSION["failed_num"]) && ($_SESSION["failed_num"]>3)) $_SESSION["failed_num"]=0;
	//if (isset($_SESSION['folder'])) unset($_SESSION['folder']);

	//echo $language;
	

	if ($action=="login")
	{
		$filter=new InputFilter;
		$_POST = $filter->safeSQL($_POST, $db->_resource);

		$username=strtolower($_POST['username']);
		$password=md5($_POST['password']);
		//$remember=$_POST['remember']; 
		$language_selected=language_info($language);
		$_SESSION['folder']=strtolower($ln->folder($language_selected));

		$signin=new signin($db, $online, $username, $password, $remember);

		if ($signin->submit_signin())
		{
			unset($_SESSION["failed_num"]);
			redirect("./cpanel.php");
		}else{
			$_SESSION["failed_num"] += 1;
			if ($_SESSION["failed_num"]>=3)
			{
				$signin->add_ip_denied();
				redirect("./denied.php");
			}//end if
			$login_failed = true;// login failed
		}//end if
	}//end if
?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><?php echo WELCOME;?></title>
	<link href="./css/style.css" rel="stylesheet" type="text/css" />
	<script language="JavaScript" src="./includes/javascript/htmljs.js"></script>
	<script language="JavaScript" src="./includes/javascript/functions.js"></script>
	<script language="JavaScript" type="text/javascript">
	<!--
		function set_focus()
		{
			var form=document.signinForm;

			form.username.select();
			form.username.focus();
		}//end function
	//-->
	</script>
	<link rel="shortcut icon" href="favicon.ico" />
	</head>
	<body onLoad="set_focus();">
	<table width="100%" height="500" border="0" cellpadding="0" cellspacing="0">
	  <tr>
		<td valign="middle">
		<?php
			if ($login_failed)
			{
				echo $draw_html->draw_error_form('370px', LOGIN_FAILED);
			}//end if
		?>
		<form id="signinForm" name="signinForm" method="post" action="<?php echo basename($_SERVER["PHP_SELF"]);?>">
		<table width="380" height="40" border="0" align="center" cellpadding="0" cellspacing="0">
		  <tr>
			<td width="10"><img src="images/trans.gif" width="1" height="1" /></td>
			<td width="40" rowspan="3"><img src="images/icon_signin.gif" width="40" height="40" align="absbottom" /></td>
			<td><img src="images/trans.gif" width="1" height="1" /></td>
		  </tr>
		  <tr>
			<td width="10" height="5"><img src="images/trans.gif" width="1" height="1" /></td>
			<td height="10"><img src="images/trans.gif" width="1" height="1" /></td>
		  </tr>
		  <tr>
		    <td width="10" height="20" class="signin">&nbsp;</td>
		    <td height="20" class="signin"><?php echo SIGNIN;?></td>
	      </tr>
		</table>
		<table width="380" border="0" align="center" cellpadding="0" cellspacing="0" class="boder_greyish">
		  <tr>
			<td class="space5px">
			<table width="100%" border="0" cellspacing="0" cellpadding="0" class="bottom_line">
			  <tr>
				<td width="40%" valign="top">
				<table width="100%" border="0" cellspacing="1" cellpadding="0">
				  <tr>
					<td class="bold"><?php echo USERNAME;?>:<br />
					  <input type="text" name="username" class="inputbox" size="20" /></td>
				  </tr>
				  <tr>
					<td class="bold"><?php echo PASSWORD?>:<br />
					  <input type="password" name="password" class="inputbox" size="20" /></td>
				  </tr>
		<!--
			<?php
				if ($ln->count_language()>1)
				{
			?>
				  <tr>
					<td><?php echo LANGUAGE;?>:<br />
					  <?php echo $ln->selectbox_language('signinForm', '', true, '');?> <img id='icon' name='icon' src="./images/<?php echo $ln->flag_icon($default["id"]);?>" width="25" height="16" align="absmiddle" />
					  </td>
				  </tr>
			<?php
				}//end if	
			?>
		//-->
				  <tr>
				    <td><input type="checkbox" name="remember" value="1" /> <?php echo REMEMBER;?></td>
				  </tr>
				  <tr>
					<td>
					  <input type="submit" name="Submit" value="<?php echo SIGN_IN?>" class="button" />
					  <input type="hidden" name="action" value="login">
					</td>
				  </tr>
				</table>
				</td>
				<td valign="top">
				<table width="100%" border="0" cellspacing="0" cellpadding="0">
				  <tr>
					<td><br />
					  <?php echo SIGNIN_NOTE1?><br /><br /><?php echo SIGNIN_NOTE2;?> <div align="center"><a href="mailto:<?php echo EMAIL_WEBMASTER;?>"><?php echo EMAIL_WEBMASTER?></a></div></td>
				  </tr>
				</table>
				</td>
			  </tr>
			</table>
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
			  <tr>
				<td align="center"><?php echo COPYRIGHT;?></td>
			  </tr>
			  <tr>
				<td align="center"><?php echo POWER_BY.' - '.VERSION;?></td>
			  </tr>
			</table></td>
		  </tr>
		</table>
		</form>
		</td>
	  </tr>
	</table>
	</body>
	</html>