<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/records.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/upload.php");
	require_once("./classes/records.php");
	require_once("./includes/define.php");
	require_once("../includes/sajax.php");
	require_once("./classes/tree.php");
	require_once("../languages/".$_SESSION['folder']."/records.php");
	require_once("./records.html.php");

	$dir_path="../filesmanager/records/";
	$action=trim(strtolower(get_param($_REQUEST, 'action', 'photos' )));
	if (($action=='') || ($action=='cancel')) $action='photos';
	$box_contract = new tree($db, $language_id, '#__record_management', '', 'contract', '');

	sajax_init();
	eval(sajax_export('customer_detail', 'contract_detail', 'contracts'));
	sajax_handle_client_request();

	header_page(MN_TRACKING_AREAS, MN_RECORD_MANAGEMENT);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
			additem($db);
			break;
		
		case "edit":
			modify($db, $_POST['contract_id']);
			break;
		
		case "remove_contract":
			remove_contract($db, $_POST['contract_id']);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`title`')));
		if (!$field_sort) $field_sort="`title`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$customer_id=intval(get_param($_REQUEST, 'customer_id', 0));
		$contract_id=intval(get_param($_REQUEST, 'contract_id', 0));
		$report=intval(get_param($_POST, 'report', 0));

		$where = array();

		if ($search) 
		{
			$where[] = '(LOWER(`title`) LIKE "%'.$search.'%")';
		}//end if

		if ($customer_id) $where[] = '`customer_id`='.$customer_id;
		if ($contract_id) $where[] = '`contract_id`='.$contract_id;
		if ($report) $where[] = '`report`='.$report;

		$sql_total=("SELECT count(*) AS num FROM `#__invoices_reports` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);
				
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_records::show($rows, $search, $_pav, $customer_id, $contract_id, $report, $error);
	}//end function

	function modify(&$db, $id)
	{
		$row = new records($db);
		if ($id)
		{
			$row->load($id);
			html_records::modify($row, $error);
		}//end if
	}//end function

	function additem(&$db)
	{
		$row = new invoices_reports($db);
		$row->bind($_POST, '');
		$num=2;
		html_records::additem($row, $num, $error);
	}//end if

	function publish(&$db, $cid=null, $publish=1)
	{
		$row = new invoices_reports($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=records&customer_id='.$_POST["customer_id"].'&contract_id='.$_POST['contract_id']);
	}//end function

	function save(&$db)
	{
		$error=false;
		if (isset($_POST['save_contract']) && ($_POST['save_contract'])) 
		{
			save_contract($db);
		}else{ 
			if (isset($_POST['contract']) && ($_POST['contract']))
			{
				$modify_date = date("Y-m-d H:m:s");
				$row = new records($db);
				$_POST["create_by"] = $_SESSION["member_id"];
				$_POST["create_date"]=$modify_date;
				$ignore=null;
				if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
				if (!$row->check()) $error=$row->get_error();
				if (!$error)
				{
					if (!$row->store()) 
						$error=$row->get_error();
				}//end if

				if ($error)
				{
					$row = new invoices_reports($db);
					$row->bind($_POST, '');
					$num=2;
					html_records::additem($row, $num, $error);
				}else{
					$contract_id=$row->id;
				}//end if
			}else{
				$contract_id=$_POST['contract_id'];
			}//end if

			if (!$error) insert_array($db, $contract_id);
		}//end if
	}//end function

	function remove(&$db, $cid)
	{	
		global $dir_path;
		$row = new invoices_reports($db);
		$error=false;

		if (count($cid))
		{
			$joins='';
			for($i=0; $i<count($cid); $i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$file=$row->delete_file($cid[$i]);
					@unlink($dir_path.$file);
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=records&customer_id='.$_POST['customer_id'].'&contract_id='.$_POST['contract_id']);
	}//end function

	function save_contract(&$db)
	{
		$error=false;
		$row=new records($db);

		$modify_date = date("Y-m-d H:m:s");
		$_POST["modify_by"] = $_SESSION["member_id"];
		$_POST["modify_date"]=$modify_date;
		
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) 
				$error=$row->get_error();
		}//end if

		if ($error)
		{
			html_records::modify($row, $error);
		}else{
			redirect('./cpanel.php?module=records&customer_id='.$row->customer_id.'&contract_id='.$row->id);	
		}//end if
	}//end fiunction

	function customers($selected='', $attribs='', $str='')
	{
		global $db;
		$db->set_query("SELECT c.`id`, c.`customer`, c.`company`, l.`name` as country FROM `#__customers` c INNER JOIN `#__locations` l ON c.`country_id`=l.`id` WHERE c.`active`=1 ORDER BY c.`customer` ASC");
		//echo $db->get_query();
		$rows=$db->load_record_list();

		$html='';
		$html.='<select name="customer_id" id="customer_id" '.$attribs.'>';
		$html.='<option value="">'.$str.'</option>';
		if ($rows)
		{
			for ($i=0, $n=count($rows); $i<$n; $i++)
			{
				$sel = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
				
				$html.='<option value='.$rows[$i]["id"].$sel.'>'.$rows[$i]['customer'].' ('.$rows[$i]['company'].' - '.$rows[$i]['country'].')'.'</option>';
			}//end for
		}//end if
		$html.='</select>';
		return $html;
	}//end function

	function remove_contract(&$db, $id)
	{
		global $dir_path;
		$row=new records($db);
		$invoices_reports=$row->delete_invoices_reports($id);
		if ($invoices_reports)
		{
			foreach ($invoices_reports as $file_delete)
			{

				@unlink($dir_path.$file_delete['filename']);
			}//end foreach
			$db->set_query('DELETE FROM `#__invoices_reports` WHERE `contract_id`='.$id);
			$db->query();
		}//end if
		$row->delete_record($id);
		redirect('./cpanel.php?module=records&customer_id='.$_POST['customer_id']);	
	}//end function


	function remove_contract_list(&$db, $id)
	{
		global $dir_path;
		$row=new records($db);
		$invoices_reports=$row->delete_invoices_reports($id);
		if ($invoices_reports)
		{
			foreach ($invoices_reports as $file_delete)
			{

				@unlink($dir_path.$file_delete['filename']);
			}//end foreach
			$db->set_query('DELETE FROM `#__invoices_reports` WHERE `contract_id`='.$id);
			$db->query();
		}//end if
		$row->delete_record($id);
		//redirect('./cpanel.php?module=records&customer_id='.$_POST['customer_id']);	
	}//end function
	
	
	function customer_detail($id)
	{
		global $db;
		$db->set_query('SELECT * FROM `#__customers` WHERE `id`='.$id);
		$row=$db->load_record();
		if ($row)
		{
			$html='<br />';
			$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td width="15%" valign="top">'.ADDRESS.':</td>';
			$html.='<td class="bold">';
			$html.=$row['address'];
			if ($row['address2']) $html.=', '.$row['address2'];
			$html.='</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td>'.EMAIL.':</td>';
			$html.='<td class="bold">';
			$html.=$row['email'];
			$html.='</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td nowrap>'.VAT.':</td>';
			$html.='<td class="bold">';
			$html.=$row['vat'];
			$html.='</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td colspan="2">'.TEL_WORK.': <span class="bold">'.$row['tel_work'].'</span> &nbsp; '.TEL_HOME.': <span class="bold">'.$row['tel_home'].'</span> &nbsp; '.MOBILE.': <span class="bold">'.$row['mobile'].'</span></td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end if
	}//end function

	function contract_detail($id)
	{
		global $db;
		$db->set_query('SELECT * FROM `#__record_management` WHERE `id`='.$id);
		$row=$db->load_record();
		if ($row)
		{
			$create_info=author_info($db, '#__members', $row["create_by"]);
			$html='<br />';
			$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td class="small">'.CREATE_DATE.': '.format_date($row['create_date']).' '.CREATE_BY.' '.$create_info['fullname'].'</td>';
			$html.='</tr>';
			$html.='</table>';
			if ($row["modify_date"]!='0000-00-00 00:00:00')
			{
				$modify_info=author_info($db, '#__members', $row["modify_by"]);
				$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
				$html.='<tr>';
				$html.='<td class="small">'.MODIFY_DATE.': '.format_date($row['modify_date']).' '.MODIFY_BY.' '.$modify_info['fullname'].'</td>';
				$html.='</tr>';
				$html.='</table>';
			}//end if
			$html.='<br />';
			$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td width="10%" valign="top">'.VALIDITY.':</td>';
			$html.='<td class="bold">';
			$html.=$row['validity'];
			$html.='</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td valign="top">'.REMARKS.':</td>';
			$html.='<td>';
			$html.=nl2br($row['remarks']);
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end if
	}//end function

	function contracts($id)
	{
		global $box_contract;
		return CONTRACT.'<br />'.$box_contract->draw_popup('contract_id', false, '', 'class="selectbox" size=1 id="contract_id"', SELECT_CONTRACT, '', ' AND `customer_id`='.$id);
	}//end function

	function insert_array(&$db, $contract_id, $number=2)
	{
		global $dir_path;

		$prefix=rand(0, 99999)."-";

		$error=array();
		for($i=0; $i<$number; $i++)
		{
			$row[$i] =& new invoices_reports($db);

			//add file attach
			$upload = new upload($_FILES['filename']['tmp_name'][$i], $dir_path, $prefix, $_FILES['filename']['name'][$i], $_FILES['filename']['size'][$i]);
			
			if ($_FILES['filename']['name'][$i])
			{
				if (!$upload->document())
				{
					$row[$i]->_error=sprintf(DOCUMENT_RECORD_FILE_NOTE, $_FILES['filename']['name'][$i]);
					//$row[$i]->_error=DOCUMENT_FILE_NOTE;
					$error[]=$row[$i]->get_error();
				}else if (!$upload->file_size()){
					$row[$i]->_error=sprintf(CHECK_RECORD_FILE_SIZE, $_FILES['filename']['name'][$i], intval(FILE_LIMIT/1048576));
					$error[]=$row[$i]->get_error();
				}else{
					if (!$upload->upload_file())
					{
						$row[$i]->_error=CHECK_SOURCE_DEST;
						$error[]=$row[$i]->get_error();
					}//end if

					$row[$i]->filename=$prefix.strtolower($upload->clear_space($_FILES["filename"]["name"][$i]));
					$row[$i]->filetype=$_FILES["filename"]["type"][$i];
					$row[$i]->customer_id=$_POST["customer_id"];
					$row[$i]->contract_id=$contract_id;
					$row[$i]->title=$_POST["title"][$i];
					$row[$i]->report=$_POST["report"][$i];

					if (!$row[$i]->check()) 
					{
						$error[]=$row[$i]->get_error();
					}else{				
						if (!$row[$i]->store())
						{
							$error[]=$row[$i]->get_error();
						}else{
							unset($row[$i]);
							//array_splice($row, $i, 1);												
						}//end if
					}//end if
				}//end if
			}//end if
			//end file attach
		}//end for

		if ($error)
		{	
			//echo '<pre>';print_r($row);echo '</pre>';
			//$num = count($row);
			//html_records::additem($row, $num, $error);
			show($db, $error);
		}else{
			redirect('./cpanel.php?module=records&customer_id='.$_POST['customer_id'].'&contract_id='.$_POST['contract_id']);
		}//end if
	}//end function

	function draw_invoices_report($selected='')
	{
		global $draw_html;
		$arr = array(
				$draw_html->make_option('0', SELECT_TYPE),
				$draw_html->make_option('1', REPORTS),
				$draw_html->make_option('2', INVOICES)
				);
		return $draw_html->selectbox($arr, 'report', 'class="selectbox" id="report" onChange="this.form.submit();"', 'value', 'text', $selected);
	}//end function

	footer_page();
?>