<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/news.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: December 27, 2007
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/tree.php");
	require_once("./classes/upload.php");
	require_once("./classes/recruitment.php");
	require_once("../languages/".$_SESSION['folder']."/recruitment.php");
	require_once("./recruitment.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$recruitment_id = intval(get_param($_REQUEST, 'recruitment_id', 0));
	
	header_page(MN_FEATURE_AREAS, MN_RECRUITMENT);
	include_once ("./includes/editor/editor.php");

	//print_r($_SESSION);

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			modify($db, $language_id, 0);
			break;
		
		case "edit":
			modify($db, $language_id, $id[0]);
			break;

		case "convert":
			if (!$recruitment_id) $recruitment_id=$id[0];
			convert($db, $recruitment_id, 0);
			break;

		case "editconvert":
			convert($db, $recruitment_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		default:
			show($db, $language_id);
			break;
	}//end switch

	function show(&$db, $language_id)
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`create_date`')));
		if (!$field_sort) $field_sort="`create_date`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'DESC'));
		if (!$sort_by) $sort_by="DESC";

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='rc.*, r.`id` AS `id_default`, r.`recruitment` AS `recruitment_default`, r.`content` AS `content_default`, r.`create_by`, r.`modify_by`, r.`create_date`, r.`modify_date`, r.`publish_date`, r.`expire_date`, r.`note`, r.`active`';
			$from='`#__recruitment_convert` rc';
			$innerjoin='RIGHT JOIN `#__recruitment` r ON r.`id`=rc.`recruitment_id` AND rc.`language_id`='.$language_id;
			if ($search) $where[] = 'LOWER(rc.`recruitment`) LIKE "%'.$search.'%" OR LOWER(rc.`content`) LIKE "%'.$search.'%"';
		}else{
			$select='r.*';
			$from='`#__recruitment` r';
			$innerjoin='';
			if ($search) $where[] = 'LOWER(r.`recruitment`) LIKE "%'.$search.'%" OR LOWER(r.`content`) LIKE "%'.$search.'%"';
		}//end if

		$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		$rows=$db->load_record_list();
		
		html_recruitment::show($language_id, $rows, $search, $_pav);
	}//end function

	function modify(&$db, $language_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$row = new recruitment($db);
		$selected=$language_id.'#'.$ln->flag_icon($language_id);
		$flag=$ln->flag_icon($language_id);

		if ($id)
		{
			$row->load($id);
		}//end if
			
		html_recruitment::modify($row, $editor, $error);
	}//end function

	function convert(&$db, $recruitment_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$content_default=content_default($db, $recruitment_id);
		$language_second = $ln->language_second();
		$selected=$language_second["id"].'#'.$language_second["icon"];
		$flag=$language_second["icon"];
		$row = new recruitment_convert($db);
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$content_default=content_default($db, $row->recruitment_id);
		}//end if
			
		html_recruitment::convert($content_default, $selected, $flag, $row, $editor, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new recruitment($db);
		$row->publish_array($cid, $publish);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=recruitment');
		redirect('./cpanel.php?module=recruitment&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id;
		$editor = new wysiwygPro();
		$error=false;
		if ($default["id"]==$language_id)
		{
			$row=new recruitment($db);
			$modify_date = date("Y-m-d H:m:s");
			if (!$_POST["id"]) 
			{
				$_POST["create_by"] = $_SESSION["member_id"];
				$_POST["create_date"]=$modify_date;
			}else{ 
				$_POST["modify_by"] = $_SESSION["member_id"];
				$_POST["modify_date"]=$modify_date;
			}//end if

			if ($_POST['publish_date']) $_POST['publish_date']=db_date($_POST['publish_date']);
			else $_POST['publish_date']= date("Y-m-d");
			if ($_POST['expire_date']) $_POST['expire_date']=db_date($_POST['expire_date']);
			else $_POST['expire_date']= date("Y-m-d");
		}else{
			$row = new recruitment_convert($db);
			$_POST["language_id"] = $language_id;
		}//end if
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			if ($default["id"]==$language_id)
			{
				html_recruitment::modify($row, $editor, $error);
			}else{
				$content_default=content_default($db, $row->recruitment_id);
				$selected=$language_id.'#'.$ln->flag_icon($language_id);
				$flag=$ln->flag_icon($language_id);
					
				html_recruitment::convert($content_default, $selected, $flag, $row, $editor, $error);
			}//end if
		}else{
			$goto = trim(strtolower(get_param( $_POST, 'goto', '' )));
			switch ($goto)
			{
				case 'convert':
					redirect('./cpanel.php?module=recruitment&action=convert&recruitment_id='.$row->id);
					break;
				
				case 'addmore':
					redirect('./cpanel.php?module=recruitment&action=new');
					break;
				
				default:
					if ($default["id"] == $language_id) redirect('./cpanel.php?module=recruitment');
					redirect('./cpanel.php?module=recruitment&show='.$row->language_id);	
					break;
			}//end switch
		}//end if
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default;
		
		$row = new recruitment($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0;$i<count($cid);$i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		redirect('./cpanel.php?module=recruitment&show='.$language_id);
	}//end function

	function content_default(&$db, $id)
	{
		if (!$id) return false;
		$row = new recruitment($db);
		$row->load($id);
		return $row;
	}//end function

	footer_page();
?>