<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/customers.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/request.form.php");
	require_once("./classes/tree.php");
	require_once("./classes/locations.php");
	require_once("../languages/".$_SESSION['folder']."/request.form.php");
	require_once("./request.form.html.php");
	require_once ('../classes/phpmailer.php');
	require_once('./includes/email_html.php');

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$box_location = new tree($db, $language_id, '#__groups_form', '', 'group', '');
	$no_convert = true;
	header_page(MN_TRACKING_AREAS, MN_REQUEST_FORM);
 	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
				modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', 'create_date')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'DESC'));
		if (!$sort_by) $sort_by="ASC";
		if(isset($_GET['group_id']))
			$group_id=intval(get_param($_GET, 'group_id', 2));	
		else
			$group_id=intval(get_param($_POST, 'group_id', 2));
		$table_form = get_table($group_id); 
		
		$where = array();
		$where[] = '`group_id`='.$group_id;
		$sql_total ="SELECT count(*) as num FROM `#__".$table_form."` as f INNER JOIN `#__customers_request` as c ON (f.customer_id = c.id) inner join `#__groups_form` as g ON (c.group_id = g.id) ". (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "");
		
		$db->set_query($sql_total);
		
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT f.*, f.id as form_id, c.*, g.group  FROM `#__".$table_form."` as f INNER JOIN `#__customers_request` as c ON (f.customer_id = c.id) inner join `#__groups_form` as g ON (c.group_id = g.id) "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY f.".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		//echo '<pre>';print_r($rows);echo '</pre>';
		
		html_request_form::show($rows, $search, $_pav, $group_id, $error);
	}//end function
	
	
	function get_country(&$db,$id)
		{
			$sql_sel='SELECT `name` FROM `#__locations` WHERE `active`=1 AND `id`='.$id;
			$db->set_query($sql_sel);
			$row=$db->load_record_list();
			if($row)
				return $row[0]['name']; 	
			else
				return "";
		}//end function
		
		
		
	function modify(&$db, $id)
	{
		$row = new request_form($db);
		$group_id=intval(get_param($_GET, 'groupid', 2));
		$table_form = get_table($group_id); 
		if ($id)
		{
			$sql="SELECT f.*, c.customer, c.country_id,c.group_id, c.company, c.address, c.address2, c.vat, c.tel_work, c.tel_home, c.mobile, c.email,c.request_date, c.status, g.group FROM `#__".$table_form."` as f INNER JOIN `#__customers_request` as c ON (f.customer_id = c.id) inner join `#__groups_form` as g ON (c.group_id = g.id) WHERE f.id=".$id ; 
			$db->set_query($sql);
			//echo $db->get_query();
			$row=$db->load_record_list();
			//echo '<pre>';print_r($row);echo '</pre>';
			$row[0]['country_id']= get_country($db,$row[0]['country_id']);
			
		}else{
			$row->bind($_POST, '');
		}//end if
		
		switch ($group_id) {
			case 2:
			   html_request_form::modify_form_inbound($row, $error);
			   break;
			case 3:
			   html_request_form::modify_form_outbound($row, $error);
			   break;
			case 4:
			   html_request_form::modify_form_national_move($row, $error);
			   break;
			case 5:
			   html_request_form::modify_form_office_move($row, $error);
			   break;
			case 6:
			   html_request_form::modify_form_pet_relocation($db, $row, $error);
			   break;
			case 7:
				html_request_form::modify_form_orientation($row, $error);
			    break;
			case 8:
				html_request_form::modify_form_home_search($row, $error);
			    break;
			case 9:
				html_request_form::modify_form_record_storage($row, $error);
			    break;
			case 10:
				html_request_form::modify_form_warehousing($row, $error);
			   break;
			case 11:
				html_request_form::modify_form_handyman_service($row, $error);
			    break;
			case 12:
				html_request_form::modify_form_insurance_claim($row, $error);
			    break;
			case 13:
				html_request_form::modify_form_exhibition($row, $error);
			    break; 
			default :
			   html_request_form::modify_form_outbound($row, $error);
			   break;         
		}
	}//end function
	function publish(&$db, $cid=null, $publish=1)
	{
		$row = new customers($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=customers');
	}//end function

	function save(&$db)
	{
		$group_id=intval(get_param($_GET, 'groupid', 2));
		switch ($group_id) {
			case 2:
			  save_inbound($db);
			   break;
			case 3:
			   save_outbound($db);
			   break;
			case 4:
			   save_national_move($db);
			   break;
			case 5:
			   save_office_move($db);
			   break;
			case 6:
			   save_pet_relocation($db);
			   break;
			case 7:
				save_orientation($db);
			    break;
			case 8:
				save_home_search($db);
			    break;
			case 9:
				save_record_storage($db);
			    break;
			case 10:
				save_warehousing($db);
			   break;
			case 11:
				save_handyman_service($db);
			    break;
			case 12:
				save_insurance_claim($db);
			    break;
			case 13:
				save_exhibition($db);
			    break; 
			default :
			   save_outbound($db);
			   break;         
		}
	}//end function

	function remove(&$db, $cid)
	{	
		$group_id=intval(get_param($_POST, 'group_id', 2));
		switch ($group_id) {
			case 2:
			  $row = new form_inbound($db);
			   break;
			case 3:
			  $row = new form_outbound($db);
			   break;
			case 4:
			   $row = new form_national_move($db);
			   break;
			case 5:
			   $row = new form_office_move($db);
			   break;
			case 6:
			   $row = new form_pet_relocation($db);
			   break;
			case 7:
				$row = new form_orientation($db);
			    break;
			case 8:
				$row = new form_home_search($db);
			    break;
			case 9:
				$row = new form_record_storage($db);
			    break;
			case 10:
				$row = new form_warehousing($db);
			   break;
			case 11:
				$row = new form_handyman_service($db);
			    break;
			case 12:
				$row = new form_insurance_claim($db);
			    break;
			case 13:
				$row = new form_exhibition($db);
			    break; 
			default :
			   $row = new form_outbound($db);
			   break;      
		}	   
		
		$error=false;
		
		if (count($cid))
		{
			$joins='';
			for($i=0; $i<count($cid); $i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=request.form&group_id='.$group_id);
	}//end function

	function request_type(&$db, $id)
	{
		$db->set_query('SELECT `group` FROM `#__group_form` WHERE `id`='.$id);
		return $db->load_result();
	}//end function
	function delete_inbound_or_outbound(&$db, $id, $new_service)
	{
		$db->set_query('SELECT `move_management` FROM `#__customers` WHERE `id`='.$id);
		$old_service=$db->load_result();

		if (($old_service) && ($old_service!=$new_service))
		{
			if ($old_service==1) $db->set_query('DELETE FROM `#__inbound` WHERE `customer_id`='.$id);
			else $db->set_query('DELETE FROM `#__outbound` WHERE `customer_id`='.$id);
			return $db->query();
		}//end if
	}//end if
	function get_table($group_id){
		switch ($group_id) {
			case 2:
			   $table_form ="form_inbound";
			   break;
			case 3:
			   $table_form ="form_outbound";
			   break;
			case 4:
			   $table_form ="form_national_move";
			   break;
			case 5:
			   $table_form ="form_office_move";
			   break;
			case 6:
			   $table_form ="form_pet_relocation";
			   break;
			case 7:
			   $table_form ="form_orientation";
			   break;
			case 8:
			   $table_form ="form_home_search";
			   break;
			case 9:
			   $table_form ="form_record_storage";
			   break;
			case 10:
			   $table_form ="form_warehousing";
			   break;
			case 11:
			   $table_form ="form_handyman_service";
			   break;
			case 12:
			   $table_form ="form_insurance_claim";
			   break;
			case 13:
			   $table_form ="form_exhibition";
			   break; 
			default :
			   $table_form ="form_outbound";  
			   break;         
		}
		return $table_form;
	}
	
	
	function save_inbound(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$inbound = new form_inbound($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=2;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$inbound->customer_id = $customer->id;
				if (!$inbound->bind($_POST, $ignore)) $error=$inbound->get_error(); 
				if (!$inbound->check())$error=$inbound->get_error();
				if ($_POST['expected_delivery_date']) $inbound->expected_delivery_date=db_date($_POST['expected_delivery_date']);
				$inbound->email_forward = $_POST['email_forward'];
				$inbound->forward_date=$request_date;
				if ($_POST['id']) $inbound->id=$_POST['id'];
				$inbound->replied=1;
				if(!$error)
					if (!$inbound->store()) $error=$inbound->get_error();
			}//end if
			$email_list = $config->email;
			
			
			$header_email1=header_email_webmaster($customer->customer, INBOUND);
			$header_email2=header_email($_POST['customer'], INBOUND);
			$customer_content=customer_content($db);
			$inbound_content=inbound_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Inbound from Saigonvan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			
			$footer_email=footer_email();
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			
			$send_webmaster.=$customer_content;
			$send_webmaster.=$inbound_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$inbound_content;
			$send_customer.=$footer_email;
			$send_customer.='</body>
				  </html>';
			$email_forward = $_POST['email_forward']; 
			
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, INBOUND, 'SAIGON VAN');
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}			
			
		}//end if
		
		
		if ($error)
		{
			html_request_form::modify_form_inbound($row, $error);
		}else{
			redirect("?module=request.form&group_id=2");
		}//end if
	}
	
	function save_outbound(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$outbound = new form_outbound($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=3;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$outbound->customer_id = $customer->id;
				if (!$outbound->bind($_POST, $ignore)) $error=$outbound->get_error(); 
				if (!$outbound->check())$error=$outbound->get_error();
				if ($_POST['expected_survey_date']) $outbound->expected_survey_date=db_date($_POST['expected_survey_date']);
				if ($_POST['expected_moving_date']) $outbound->expected_moving_date=db_date($_POST['expected_moving_date']);
				$outbound->email_forward = $_POST['email_forward'];
				$outbound->forward_date=$request_date;
				if ($_POST['id']) $outbound->id=$_POST['id'];
				$outbound->replied=1;
				if(!$error)
					if (!$outbound->store()) $error=$outbound->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, OUTBOUND);
			
			$header_email2=header_email($_POST['customer'], OUTBOUND);
			$customer_content=customer_content($db);
			$outbound_content=outbound_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Outbound from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			
			$footer_email=footer_email();
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;

			$send_webmaster.=$customer_content;
			$send_webmaster.=$outbound_content;
			
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
									
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$outbound_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, OUTBOUND, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}		
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_outbound($row, $error);
		}else{
			redirect("?module=request.form&group_id=3");
		}//end if
	}
	
	
	function save_national_move(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$national_move = new form_national_move($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=4;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$national_move->customer_id = $customer->id;
				if (!$national_move->bind($_POST, $ignore)) $error=$national_move->get_error(); 
				if (!$national_move->check())$error=$national_move->get_error();
				if ($_POST['expected_survey_date']) $national_move->expected_survey_date=db_date($_POST['expected_survey_date']);
				if ($_POST['expected_moving_date']) $national_move->expected_moving_date=db_date($_POST['expected_moving_date']);
				$national_move->email_forward = $_POST['email_forward'];
				$national_move->forward_date=$request_date;
				if ($_POST['id']) $national_move->id=$_POST['id'];
				$national_move->replied=1;
				if(!$error)
					if (!$national_move->store()) $error=$national_move->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, NATIONAL_MOVE);
			$header_email2=header_email($_POST['customer'], NATIONAL_MOVE);
			$customer_content=customer_content($db);
			$national_move_content=national_move_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - National Move from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			
			$footer_email=footer_email();
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
	
			$send_webmaster.=$customer_content;
			$send_webmaster.=$national_move_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$national_move_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, NATIONAL_MOVE, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}		
			

		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_national_move($row, $error);
		}else{
			redirect("?module=request.form&group_id=4");
		}//end if
	}
	
	function save_office_move(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$office_move = new form_office_move($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=5;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$office_move->customer_id = $customer->id;
				if (!$office_move->bind($_POST, $ignore)) $error=$office_move->get_error(); 
				if (!$office_move->check())$error=$office_move->get_error();
				if ($_POST['expected_survey_date']) $office_move->expected_survey_date=db_date($_POST['expected_survey_date']);
				if ($_POST['expected_moving_date']) $office_move->expected_moving_date=db_date($_POST['expected_moving_date']);
				if ($_POST['id']) $office_move->id=$_POST['id'];
				$office_move->email_forward = $_POST['email_forward'];
				$office_move->forward_date=$request_date;
				$office_move->replied=1;
				if(!$error)
					if (!$office_move->store()) $error=$office_move->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, OFFICE_MOVE);
			$header_email2=header_email($_POST['customer'], OFFICE_MOVE);
			$customer_content=customer_content($db);
			$office_move_content=office_move_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Office Move from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$office_move_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$office_move_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, OFFICE_MOVE, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_office_move($row, $error);
		}else{
			redirect("?module=request.form&group_id=5");
		}//end if
	}
	
	function save_pet_relocation(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$pet_relocation = new form_pet_relocation($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=6;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$pet_relocation->customer_id = $customer->id;
				if (!$pet_relocation->bind($_POST, $ignore)) $error=$pet_relocation->get_error(); 
				if (!$pet_relocation->check())$error=$pet_relocation->get_error();
				if ($_POST['id']) $pet_relocation->id=$_POST['id'];
				if ($_POST['date_of_travel']) $pet_relocation->date_of_travel=db_date($_POST['date_of_travel']);
				$pet_relocation->email_forward = $_POST['email_forward'];
				$pet_relocation->forward_date=$request_date;
				$pet_relocation->replied=1;
				if(!$error)
					if (!$pet_relocation->store()) $error=$pet_relocation->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, PET_RELOCATION);
			$header_email2=header_email($_POST['customer'], PET_RELOCATION);
			$customer_content=customer_content($db); 
			$pet_relocation_content=pet_relocation_content($db);
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Pet Relocations from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			
			$send_webmaster.=$pet_relocation_content;
			$send_webmaster.=$footer_email;

			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$pet_relocation_content;
			
			$send_customer.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, PET_RELOCATION, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_pet_relocation($row, $error);
		}else{
			redirect("?module=request.form&group_id=6");
		}//end if
	}
	
	function save_orientation(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$orientation = new form_orientation($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=7;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$orientation->customer_id = $customer->id;
				if (!$orientation->bind($_POST, $ignore)) $error=$orientation->get_error(); 
				if (!$orientation->check())$error=$orientation->get_error();
				if ($_POST['id']) $orientation->id=$_POST['id'];
				if ($_POST['date_of_last_visit']) $orientation->date_of_last_visit=db_date($_POST['date_of_last_visit']);
				$orientation->forward_date=$request_date;
				$orientation->email_forward = $_POST['email_forward'];
				$orientation->service_home_search = isset($_POST['service_home_search'])?1:0;
				$orientation->service_schooling = isset($_POST['service_schooling'])?1:0;
				$orientation->service_culture = isset($_POST['service_culture'])?1:0;
				$orientation->service_cleaning = isset($_POST['service_cleaning'])?1:0;
				$orientation->service_handyman = isset($_POST['service_handyman'])?1:0;
				$orientation->service_maid = isset($_POST['service_maid'])?1:0;
				$orientation->service_banking = isset($_POST['service_banking'])?1:0;
				$orientation->service_internet = isset($_POST['service_internet'])?1:0;
				$orientation->replied=1;
				if(!$error)
					if (!$orientation->store()) $error=$orientation->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, ORIENTATION);
			$header_email2=header_email($_POST['customer'], ORIENTATION);
			$customer_content=customer_content($db);
			$orientation_content=orientation_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Orientation from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$orientation_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
								
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$orientation_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, ORIENTATION, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_orientation($row, $error);
		}else{
			redirect("?module=request.form&group_id=7");
		}//end if
	}
	
	
	function save_home_search(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$home_search = new form_home_search($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=8;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$home_search->customer_id = $customer->id;
				if (!$home_search->bind($_POST, $ignore)) $error=$home_search->get_error(); 
				if (!$home_search->check())$error=$home_search->get_error();
				
				if ($_POST['id']) $home_search->id=$_POST['id'];
				if ($_POST['expect_move_in_date']) $home_search->expect_move_in_date=db_date($_POST['expect_move_in_date']);
				$home_search->forward_date=$request_date;
				$home_search->email_forward = $_POST['email_forward'];
				$home_search->replied=1;
				if(!$error)
					if (!$home_search->store()) $error=$home_search->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, HOME_SEARCH_FORM);
			$header_email2=header_email($_POST['customer'], HOME_SEARCH_FORM);
			$customer_content=customer_content($db);
			$home_search_content=home_search_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Housing from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$home_search_content;
			
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$home_search_content;
			$send_customer.=$footer_email;

			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, HOME_SEARCH_FORM, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_home_search($row, $error);
		}else{
			redirect("?module=request.form&group_id=8");
		}//end if
	}
	
	function save_record_storage(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$record_storage = new form_record_storage($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=9;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$record_storage->customer_id = $customer->id;
				if (!$record_storage->bind($_POST, $ignore)) $error=$record_storage->get_error(); 
				if (!$record_storage->check())$error=$record_storage->get_error();
				if ($_POST['id']) $record_storage->id=$_POST['id'];
				if ($_POST['expect_move_in_date']) $record_storage->expect_move_in_date=db_date($_POST['expect_move_in_date']);
				$record_storage->forward_date=$request_date;
				$record_storage->email_forward = $_POST['email_forward'];
				$record_storage->replied=1;
				if(!$error)
					if (!$record_storage->store()) $error=$record_storage->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, RECORD_STORAGE);
			$header_email2=header_email($_POST['customer'], RECORD_STORAGE);
			$customer_content=customer_content($db);
			$record_storage_content=record_storage_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Record Storage from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$record_storage_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$record_storage_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, RECORD_STORAGE, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_record_storage($row, $error);
		}else{
			redirect("?module=request.form&group_id=9");
		}//end if
	}
	
	
	function save_warehousing(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$warehousing = new form_warehousing($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=10;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$warehousing->customer_id = $customer->id;
				if (!$warehousing->bind($_POST, $ignore)) $error=$warehousing->get_error(); 
				if (!$warehousing->check())$error=$warehousing->get_error();
				if ($_POST['id']) $warehousing->id=$_POST['id'];
				if ($_POST['expect_move_in_date']) $warehousing->expect_move_in_date=db_date($_POST['expect_move_in_date']);
				$warehousing->email_forward = $_POST['email_forward'];
				$warehousing->forward_date=$request_date;
				$warehousing->replied=1;
				if(!$error)
					if (!$warehousing->store()) $error=$warehousing->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email($_POST['email_forward'], WAREHOUSING);
			$header_email2=header_email($_POST['customer'], WAREHOUSING);
			$customer_content=customer_content($db);
			$warehousing_content=warehousing_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Warehousing from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$warehousing_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';	
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$warehousing_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, WAREHOUSING, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_warehousing($row, $error);
		}else{
			redirect("?module=request.form&group_id=10");
		}//end if
	}
	
	function save_handyman_service(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$handyman_service = new form_handyman_service($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=11;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$handyman_service->customer_id = $customer->id;
				if (!$handyman_service->bind($_POST, $ignore)) $error=$handyman_service->get_error(); 
				if (!$handyman_service->check())$error=$handyman_service->get_error();
				if ($_POST['date_of_service']) $handyman_service->date_of_service=db_date($_POST['date_of_service']);
				if ($_POST['id']) $handyman_service->id=$_POST['id'];
				$handyman_service->email_forward = $_POST['email_forward'];
				$handyman_service->forward_date=$request_date;
				$handyman_service->replied=1;
				if(!$error)
					if (!$handyman_service->store()) $error=$handyman_service->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, HANDYMAN_SERVICE);
			$header_email2=header_email($_POST['customer'], HANDYMAN_SERVICE);
			$customer_content=customer_content($db);
			$handyman_service_content=handyman_service_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Handyman Service from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$handyman_service_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$handyman_service_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, HANDYMAN_SERVICE, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_handyman_service($row, $error);
		}else{
			redirect("?module=request.form&group_id=11");
		}//end if
	}
	
	function save_insurance_claim(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$insurance_claim = new form_insurance_claim($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=12;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$insurance_claim->customer_id = $customer->id;
				if (!$insurance_claim->bind($_POST, $ignore)) $error=$insurance_claim->get_error(); 
				if (!$insurance_claim->check())$error=$insurance_claim->get_error();
				if ($_POST['id']) $insurance_claim->id=$_POST['id'];
				$insurance_claim->email_forward = $_POST['email_forward'];
				$insurance_claim->forward_date=$request_date;
				$insurance_claim->replied=1;
				if(!$error)
					if (!$insurance_claim->store()) $error=$insurance_claim->get_error();
			}//end if
			$email_list = $config->email;
			$attach ="";
			$header_email1=header_email_webmaster($customer->customer, INSURANCE_CLAIM);
			$header_email2=header_email($_POST['customer'], INSURANCE_CLAIM);
			$customer_content=customer_content($db);
			$insurance_claim_content=insurance_claim_content($attach);
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Insurance & Claim from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$insurance_claim_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$insurance_claim_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, INSURANCE_CLAIM, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_insurance_claim($row, $error);
		}else{
			redirect("?module=request.form&group_id=12");
		}//end if
	}
	
	
	function save_exhibition(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$exhibition = new form_exhibition($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=13;
		$customer->status=1;
		if ($_POST['customer_id']) $customer->id=$_POST['customer_id'];
		//if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$exhibition->customer_id = $customer->id;
				if (!$exhibition->bind($_POST, $ignore)) $error=$exhibition->get_error(); 
				if (!$exhibition->check())$error=$exhibition->get_error();
				if ($_POST['date_of_exhibition']) $exhibition->date_of_exhibition=db_date($_POST['date_of_exhibition']);
				if ($_POST['id']) $exhibition->id=$_POST['id'];
				$exhibition->email_forward = $_POST['email_forward'];
				$exhibition->forward_date=$request_date;
				
				$exhibition->replied=1;
				if(!$error)
					if (!$exhibition->store()) $error=$exhibition->get_error();
			}//end if
			$email_list = $config->email;
			$header_email1=header_email_webmaster($customer->customer, EXHIBITION);
			$header_email2=header_email($_POST['customer'], EXHIBITION);
			$customer_content=customer_content($db);
			$exhibition_content=exhibition_content();
			$forward_content ='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>SaigonVan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>';
			$forward_content .= '<table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$forward_content.=$customer->customer;
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$forward_content.=$email_list;
					$forward_content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$forward_content.=show_date($_POST['create_date']);
					$forward_content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$forward_content.= "Request - Exhibition from SaigonVan.com ". $customer->customer;
					$forward_content.='<br />
<br />
<br />
</td>
					</tr>';
			$footer_email=footer_email();
			
			$send_webmaster=$forward_content;
			$send_webmaster.=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$exhibition_content;
			$send_webmaster.=$footer_email;
			$send_webmaster.='</body>
				  				</html>';
			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$exhibition_content;
			$send_customer.=$footer_email;

			//echo $send_webmaster;
			//echo $send_customer;
			$email_forward = $_POST['email_forward']; 
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT3, EXHIBITION, $_POST['customer']);
				$mail->MsgHTML($send_webmaster);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
		}//end if
		
		if ($error)
		{
			html_request_form::modify_form_exhibition($row, $error);
		}else{
			redirect("?module=request.form&group_id=13");
		}//end if
	}
	
	
	footer_page();
?>