<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/banners.php 
	# Description: This file's the access to module banners.
	# Write by: Le Hung
	# Start time: December 26, 2007
	# Last update: January 28, 2008
	*/

	include_once("./logged.php");
	require_once("./classes/tmp.php");
	require_once("../languages/".$_SESSION['folder']."/city.php");
	require_once("./tmp.html.php");
	require_once("./classes/tree.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$name_id = intval(get_param($_REQUEST, 'name_id', 0));
	
	$error=null;
	if (($action=='editconvert') && (!$id[0]))
	{
	 	$action='';
		$error= CONVERT_ERROR;
	}//end if

	$box_parent=new tree($db, $language_id, '#__city', '#__city_convert', 'name', 'name_id');

	header_page(MN_FEATURE_AREAS, MN_HOME_SEARCH.' :: '.MN_LOCATION);

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;

		case "convert":
			if (!$name_id) $name_id=$id[0];
			convert($db, $name_id, 0);
			break;

		case "editconvert":
			convert($db, $name_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		case "saveorder":
			saveordering($db, $language_id, $id);
			break;
		
		case "orderup":
			move($db, $language_id, -1, $id[0]);
			break;
		
		case "orderdown":
			move($db, $language_id, 1, $id[0]);
			break;
		
		default:
			show($db, $language_id, $error);
			break;
	}//end switch

	function show(&$db, $language_id, $error='')
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$parent_id = intval(get_param($_POST, 'parent_id', 0));

		$where = array();


			$select='c.*';
			$from='`#__language` c';
			$innerjoin='';
			if ($search) $where[] = '(LOWER(c.`name`) LIKE "%'.$search.'%")';
			$sort='c';


		if ($parent_id) $where[] = 'c.`parent_id`='.$parent_id;

		$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				//. "\n ORDER BY ".$sort.".".$field_sort." ".$sort_by
				. "\n ORDER BY c.`id` ASC"
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_city::show($language_id, $rows, $search, $_pav, $error, $parent_id);
	}//end function

	function modify(&$db, $id)
	{
		$row = new tmp($db);
		if ($id)
		{
			$row->load($id);
		}//end if
			
		html_city::modify($row, $error);
	}//end function

	function convert(&$db, $name_id, $id)
	{
		global $ln;

		$content_default=content_default($db, $name_id);
		$language_second = $ln->language_second();
		$selected=$language_second["id"].'#'.$language_second["icon"];
		$flag=$language_second["icon"];
		$row = new city_convert($db);
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$content_default=content_default($db, $row->name_id);
		}//end if
			
		html_city::convert($content_default, $selected, $flag, $row, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new city($db);
		$row->publish_array($cid, $publish);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=city');
		redirect('./cpanel.php?module=city&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id;
		$error=false;
		$row=new tmp($db);
		

		//print_r($_POST);exit();
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) 
			{
				$error=$row->get_error();
			}
		}//end if

		redirect('./cpanel.php?module=tmp');
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default;
		
		$row=($default["id"]==$language_id)?new city($db):new city_convert($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0; $i<count($cid); $i++)
			{
				if ($default["id"]==$language_id)
				{
					$sql_del="DELETE FROM `#__city_convert` WHERE `name_id`=".$cid[$i];
					$db->set_query($sql_del);
					$db->query();
				}//end if
				$row->delete_record($cid[$i]);
			}//end for
		}//end if


		if ($default["id"]==$language_id) redirect('./cpanel.php?module=city');
		redirect('./cpanel.php?module=city&show='.$language_id);
	}//end function

	function content_default(&$db, $id)
	{
		if (!$id) return false;
		$row = new city($db);
		$row->load($id);
		return $row;
	}//end function

	function saveordering(&$db, $language_id, $id) 
	{
		global $default;
		$total = count($id);
		$order = get_param( $_POST, 'order', array(0) );
		$row = new city($db);
		$conditions = array();
		
    	// update ordering values
		for( $i=0; $i < $total; $i++ ) 
		{
			$row->load($id[$i] );
			if ($row->ordering != $order[$i]) 
			{
				$row->ordering = $order[$i];
	        	if (!$row->store()) 
				{
	            	echo "<script> alert('".$db->get_error()."'); window.history.go(-1); </script>\n";
	            	exit();
	        	}//end if
				
	        	// remember to updateOrder this group
	        	$condition="`parent_id`=".$row->parent_id;
	        	$found = false;
	        	
				foreach ($conditions as $cond)
				{
	            	if ($cond[1]==$condition) 
					{
	                	$found = true;
	                	break;
	            	}//end if
				}//end foreach
				
	        	if (!$found) $conditions[] = array($row->id, $condition);
			}//end if
		}//end for
		
		// execute updateOrder for each group
		foreach ($conditions as $cond) 
		{
			$row->load($cond[0]);
			$row->update_order($cond[1]);
		}//end foreach
		
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=city');
		redirect('./cpanel.php?module=city&show='.$language_id);
	}//end function

	function move(&$db, $language_id, $inc, $id) 
	{
		global $default;
		$row = new city($db);
		$row->load($id);
		$row->move($inc, "`parent_id`=".$row->parent_id);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=city');
		redirect('./cpanel.php?module=city&show='.$language_id);
	}//end function

	footer_page();
?>