<?php

	/*
		Jax Captcha Class v1.o1 - Copyright (c) 2005, Andreas John aka Jack (tR)
		This program and it's moduls are Open Source in terms of General Public License (GPL) v2.0
	
		class.captcha.php 		(captcha class module)
		
		Last modification: 2005-09-05
	*/
	
	class captcha
	{
		var $session_key = null;
		var $temp_dir    = null;
		var $width       = 90;
		var $height      = 20;
		var $jpg_quality = 100;
		
		
		/**
		 * Constructor - Initializes Captcha class!
		 *
		 * @param string $session_key
		 * @param string $temp_dir
		 * @return captcha
		 */
		function captcha( $session_key, $temp_dir )
		{
			$this->session_key = $session_key;
			$this->temp_dir    = $temp_dir;
		}
		
				
		/**
		 * Generates Image file for captcha
		 *
		 * @param string $location
		 * @param string $char_seq
		 * @return unknown
		 */
		function _generate_image( $location, $char_seq )
		{
			$num_chars = strlen($char_seq);
			
			$img = imagecreatetruecolor( $this->width, $this->height );
			imagealphablending($img, 1);
			imagecolortransparent( $img );
			
			// generate background of randomly built ellipses
			
				$r = 242;
				$g = 242;
				$b = 242;
				$color = imagecolorallocate( $img, $r, $g, $b );
				imagefilledellipse( $img,15, 15, 200, 80, $color );	
			
			
			$start_x = round($this->width / $num_chars);
			$max_font_size = 12;
			$start_x = 1;
			$max_x_ofs = 15;
			
			// set each letter with random angle, size and color
			for ($i=0;$i<=$num_chars;$i++)
			{
				$r = 167;
				$g = 13;
				$b = 14;
				$y_pos = 17;
				
				$fontsize = round( rand( 12, $max_font_size) );
				$color = imagecolorallocate( $img, $r, $g, $b);
				$presign = 0;
				$angle = 0;
				if ($presign==true) $angle = -1*$angle;
				
				ImageTTFText( $img, $fontsize, $angle, $start_x+$i*$max_x_ofs, $y_pos, $color, 'default.ttf', substr($char_seq,$i,1) );
			}
			
			// create image file
			imagejpeg( $img, $location, $this->jpg_quality );
			flush();
			imagedestroy( $img );
				
			return true;
		}
		
		
		/**
		 * Returns name of the new generated captcha image file
		 *
		 * @param unknown_type $num_chars
		 * @return unknown
		 */
		function get_pic( $num_chars=8 )
		{
			// define characters of which the captcha can consist
			$alphabet = array( 
				'A','B','C','D','E','F','G','H','I','J','K','L','M',
				'N','O','P','Q','R','S','T','U','V','W','X','Y','Z',
				'1','2','3','4','5','6','7','8','9','0' );
				
			$max = sizeof( $alphabet );
			
			// generate random string
			$captcha_str = '';
			for ($i=1;$i<=$num_chars;$i++) // from 1..$num_chars
			{
				// choose randomly a character from alphabet and append it to string
				$chosen = rand( 1, $max );
				$captcha_str .= $alphabet[$chosen-1];
			}
			
			// generate a picture file that displays the random string
			if ( $this->_generate_image( $this->temp_dir.'/'.'cap_'.md5( strtolower( $captcha_str )).'.jpg' , $captcha_str ) )
			{
				$fh = fopen( $this->temp_dir.'/'.'cap_'.$this->session_key.'.txt', "w" );
				fputs( $fh, md5( strtolower( $captcha_str ) ) );
				return( md5( strtolower( $captcha_str ) ) );
			}
			else 
			{
				return false;
			}
		}
		
		/**
		 * check hash of password against hash of searched characters
		 *
		 * @param string $char_seq
		 * @return boolean
		 */
		function verify( $char_seq )
		{
			$fh = fopen( $this->temp_dir.'/'.'cap_'.$this->session_key.'.txt', "r" );
			$hash = fgets( $fh );
			
			if (md5(strtolower($char_seq)) == $hash)
				return true;
			else 
				return false;			
		}		
	}


?>