<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: classes/download.php  
	# Description: 
	# Write by: Le Hung
	# Start time: December 11, 2007
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class download
	{
		var $_path = "";
		var $_type = "";
		var $_disposition = "";
		var $_filename = "";

		function download($path, $filename = "", $type = "application/octet-stream", $disposition = "attachment") 
		{
			$this->_path = $path;
			$this->_type = $type;
			$this->_disposition = $disposition;
			$this->_filename = ($filename)? $filename : basename($path);
		}//end function

		// check is specified file exists?
		function df_exists() 
		{
			if (file_exists($this->_path)) return true;
			return false;
		}//end function

		// get file size
		function df_size() 
		{
			if($this->df_exists()) return filesize($this->_path.$this->_filename);
			return false;
		}//end function

		// return permission number for user 'other'
		function df_permitother() 
		{
			return substr(decoct(fileperms($this->_path)),-1);
		}//end function

		// download file
		function df_download() 
		{
			if($this->df_exists() && $this->df_permitother() >= 4) 
			{
				header("Content-type: ".$this->_type);
				header("Content-Disposition: ".$this->_disposition."; filename=\"".$this->_filename."\"");
				header("Content-Length: ".$this->df_size());

				$fp = readfile($this->_path.$this->_filename, "r");
				return $fp;
			}//end if
			return false;
		}//end function
	}//end class
?>