<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : classes/errorform.php
	# Description: The errorform class is meant to simplify the task 
				   of keeping track of errors in user submitted forms 
				   and the form field values that were entered correctly.
	# Write by: Le Hung
	# Start time: September, 18 2007
	# Last update: September, 18 2007
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class errorform
	{
		var $values = array();  //Holds submitted form field values
		var $errors = array();  //Holds submitted form error messages
		var $num_errors = null;   //The number of errors in submitted form

		function errorform()
		{
			///Get form value and error arrays, used when there is an error with a user-submitted form.
			if (isset($_SESSION['value_array']) && isset($_SESSION['error_array']))
			{
				$this->values = $_SESSION['value_array'];
				$this->errors = $_SESSION['error_array'];
				$this->num_errors = count($this->errors);

				unset($_SESSION['value_array']);
				unset($_SESSION['error_array']);
			}else{
				$this->num_errors = 0;
			}//end if
		}//end function

		//set_value - Records the value typed into the given form field by the user.
		function set_value($field, $value)
		{
			$this->values[$field] = $value;
		}//end function

		//set_error - Records new form error given the form field name and the error message attached to it.
		function set_error($field, $errmsg)
		{
			$this->errors[$field] = $errmsg;
			$this->num_errors = count($this->errors);
		}//end function

		//value - Returns the value attached to the given field, if none exists, the empty string is returned.
		function value($field)
		{
			if (array_key_exists($field, $this->values)) return htmlspecialchars(stripslashes($this->values[$field]));
			return "";
		}//end function

		//error - Returns the error message attached to the given field, if none exists, the empty string is returned.
		function error($field)
		{
			if (array_key_exists($field,$this->errors)) return '<span class="error">'.$this->errors[$field].'</span>';
			return "";
		}//end function

		///get_error_array - Returns the array of error messages 
		function get_error_array()
		{
			return $this->errors;
		}//end function
	}//end class
?>