<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: classes/customers.request.php 
	# Description: The contents class is meant to simplify the task of module content.
	# Write by: Le Hung
	# Start time: 
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class form_home_search extends access_database
	{
		var $id = null;
		var $customer_id = null;
		var $property = null;
		var $property_other = null; 
		var $furniture = null; 
		var $furniture_other = null; 
		var $bedroom = null; 
		var $bedroom_other = null; 
		var $monthly_budget = null;
		var $monthly_budget_other = null;
		var $terms_of_lease = null;
		var $terms_of_lease_other = null;
		var $info1 = null;
		var $info2 = null;
		var $info3 = null;
		var $expect_move_in_date = null; 
		var $create_date = null;

		function form_home_search(&$db) 
		{
			$this->access_database( '`#__form_home_search`', 'id', $db);
		}//end function
	}//end class

	class homes
	{
		var $_db = null;
		var $_default = null;
		var $_language_id = null;
		var $_html = null;

		function homes(&$db, $default, $language_id) 
		{
			$this->_db=&$db;
			$this->_default=$default;
			$this->_language_id=$language_id;
		}//end function	

		function draw_type($selected='', $attribs='', $str=SELECT_TYPE)
		{
			global $default;

			$this->_html ='';
			if ($this->_default['id']==$this->_language_id) 
			{
				$this->_db->set_query("SELECT `id`, `type` FROM `#__type` WHERE `active`=1 ORDER BY `ordering` ASC");
			}else{ 
				$this->_db->set_query("SELECT t.`id`, tc.`type`  FROM `#__type_convert` tc RIGHT JOIN `#__type` t ON t.`id`=tc.`type_id` AND tc.`language_id`=".$this->_language_id." ORDER BY t.`ordering` ASC");
			}//end if
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();

			if ($rows)
			{
				$this->_html.='<select name="type_id" '.$attribs.'>';
				$this->_html.='<option value="">'.$str.'</option>';
				for ($i=0, $n=count($rows); $i<$n; $i++)
				{
					$sel_0 = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
					
					$this->_html.= '<option value='.$rows[$i]['id'].$sel_0.'>'.$rows[$i]['type'].'</option>';
				}//end for
				$this->_html.='</select>';
			}else{
				$this->_html.='<select name="disable" disabled="disabled" class="selectbox" style="width:160px">';
				$this->_html.='<option value="">'.$str.'</option>';
				$this->_html.='</select>';
			}//end if
			return $this->_html;
		}//enf function

		function show($city_id='', $district_id='', $type_id='', $limitstart, $limit, $url='')
		{	
			$where = array();
			if ($this->_default['id']==$this->_language_id)
			{
				$select='h.*';
				$from='`#__homes` h';
				$innerjoin='';
			}else{
				$select='h.*, hc.`field_name1`, hc.`field_value1`, hc.`field_name2`, hc.`field_value2`, hc.`field_name3`, hc.`field_value3`, hc.`field_name4`, hc.`field_value4`, hc.`other_info`, hc.`address_code`, hc.`landlord`, hc.`address_contact`';
				$from='`#__homes_convert` hc';
				$innerjoin='RIGHT JOIN `#__homes` h ON h.`id`=hc.`home_id` AND hc.`language_id`='.$this->_language_id;
			}//end if
			$where[]='h.`active`=1';
			if ($city_id) $where[]='h.`city_id`='.$city_id;
			if ($district_id) $where[]='h.`district_id`='.$district_id;
			if ($type_id) $where[]='h.`type_id`='.$type_id;
			
			$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
					 . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
			$this->_db->set_query($sql_total);
			//echo $this->_db->get_query();	
			$total=$this->_db->load_result();

			include_once(DIR_FS_CLASSES."pages.php");
			$_pav = new pages($total, $limitstart, $limit);
			$leafs_counter=$_pav->leafs_counter();
			$this->_link=$url;
			$page_links=$_pav->pages_links($this->_link);

			$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				   . (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				   . "\n ORDER BY h.`modify_date` ASC, h.`create_date` ASC"
				   . "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
			$this->_db->set_query($sql_sel);
			//echo $this->_db->get_query();
			$rows=$this->_db->load_record_list();
			if (!$rows) return false;
			foreach ($rows as $k=>$v)
			{
				if ($this->_default['id']==$this->_language_id)
				{
					$this->_db->set_query('SELECT `type` FROM `#__type` WHERE `id`='.$v['type_id']);
					$rows[$k]['type']=$this->_db->load_result();
				}else{
					$this->_db->set_query('SELECT tc.`type` FROM `#__type_convert` tc RIGHT JOIN `#__type` t ON t.`id`=tc.`type_id` AND tc.`language_id`='.$this->_language_id.' WHERE t.`id`='.$v['type_id']);
					//echo $this->_db->get_query();
					$rows[$k]['type']=$this->_db->load_result();
				}//end if

				if ($this->_default['id']==$this->_language_id)
				{
					$this->_db->set_query('SELECT `name` FROM `#__city` WHERE `id`='.$v['city_id']);
					$rows[$k]['city']=$this->_db->load_result();
				}else{
					$this->_db->set_query('SELECT cc.`name` FROM `#__city_convert` cc RIGHT JOIN `#__city` c ON c.`id`=cc.`name_id` AND cc.`language_id`='.$this->_language_id.' WHERE c.`id`='.$v['city_id']);
					$rows[$k]['city']=$this->_db->load_result();
				}//end if

				if ($this->_default['id']==$this->_language_id)
				{
					$this->_db->set_query('SELECT `name` FROM `#__city` WHERE `id`='.$v['district_id']);
					$rows[$k]['district']=$this->_db->load_result();
				}else{
					$this->_db->set_query('SELECT cc.`name` FROM `#__city_convert` cc RIGHT JOIN `#__city` c ON c.`id`=cc.`name_id` AND cc.`language_id`='.$this->_language_id.' WHERE c.`id`='.$v['district_id']);
					$rows[$k]['district']=$this->_db->load_result();
				}//end if
			}//end foreach
			
			return array("rows"=>$rows, "leafs_counter"=>$leafs_counter, "page_links"=>$page_links);
		}//end function

		function detail($id)
		{
			if ($this->_default['id']==$this->_language_id)
			{
				$this->_db->set_query('SELECT * FROM `#__homes` WHERE `id`='.$id);
			}else{
				$this->_db->set_query('SELECT h.*, hc.`field_name1`, hc.`field_value1`, hc.`field_name2`, hc.`field_value2`, hc.`field_name3`, hc.`field_value3`, hc.`field_name4`, hc.`field_value4`, hc.`other_info`, hc.`address_code`, hc.`landlord`, hc.`address_contact` FROM `#__homes_convert` hc RIGHT JOIN `#__homes` h ON h.`id`=hc.`home_id` AND hc.`language_id`='.$this->_language_id.' WHERE h.`id`='.$id);
			}//end if
			$row = $this->_db->load_record();
			if (!$row) return false;
			
			if ($this->_default['id']==$this->_language_id)
			{
				$this->_db->set_query('SELECT `type` FROM `#__type` WHERE `id`='.$row['type_id']);
				$row['type']=$this->_db->load_result();
			}else{
				$this->_db->set_query('SELECT tc.`type` FROM `#__type_convert` tc RIGHT JOIN `#__type` t ON t.`id`=tc.`type_id` AND tc.`language_id`='.$this->_language_id.' WHERE t.`id`='.$row['type_id']);
				//echo $this->_db->get_query();
				$row['type']=$this->_db->load_result();
			}//end if

			if ($this->_default['id']==$this->_language_id)
			{
				$this->_db->set_query('SELECT `name` FROM `#__city` WHERE `id`='.$row['city_id']);
				$row['city']=$this->_db->load_result();
			}else{
				$this->_db->set_query('SELECT cc.`name` FROM `#__city_convert` cc RIGHT JOIN `#__city` c ON c.`id`=cc.`name_id` AND cc.`language_id`='.$this->_language_id.' WHERE c.`id`='.$row['city_id']);
				$row['city']=$this->_db->load_result();
			}//end if

			if ($this->_default['id']==$this->_language_id)
			{
				$this->_db->set_query('SELECT `name` FROM `#__city` WHERE `id`='.$row['district_id']);
				$row['district']=$this->_db->load_result();
			}else{
				$this->_db->set_query('SELECT cc.`name` FROM `#__city_convert` cc RIGHT JOIN `#__city` c ON c.`id`=cc.`name_id` AND cc.`language_id`='.$this->_language_id.' WHERE c.`id`='.$row['district_id']);
				$row['district']=$this->_db->load_result();
			}//end if
			
			$this->_db->set_query('SELECT * FROM `#__home_photos` WHERE `home_id`='.$row['id'].' AND `active`=1 ORDER BY `id` ');
			$row['photos']=$this->_db->load_record_list();
			if($row['photos'])
				$row['update_date']= isset($row['update_date'])?$this->Date_format($row['update_date'],$_SESSION['language_id']):"";
			return $row;
		}//end if
		function Date_format($date,$lang){
			$strDate="";
			if($date=="" || $date =='0000-00-00'){
				return $strDate;
			}else{
				$strDate= explode("-",$date);
				if($lang==1){
					$strDate = $this->returnDate($strDate[1], "month",$lang) . ", " . $strDate[2] . " " . $strDate[0]; 
				}else{
					$strDate = $strDate[1] ." 月 ". $strDate[2] . " 日 " . $strDate[0]. " 年" ;
				}
				return $strDate;
			}	
		}
		function returnDate($num, $type){ 
			$str=""; 
			switch($type){ 
				case "month": 
					$month_name = array("", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"); 
					$str = $month_name[floor($num)]; 
					break; 
				case "day": 
					$day_name = array("", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu", "Minggu"); 
					$str = $day_name[floor($num)]; 
					break; 
			} 
			return $str; 
		} 
		
	}//end class
?>