<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : classes/language.php
	# Description: The language class is meant to simplify the task of language 
				   using in the website.
	# Write by: Le Hung
	# Start time: September 24, 2007
	# Last update: November 13, 2007
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');
	class language
	{
		var $language_id = null;	//language id selected 
		var $_db		 = null;	//connection to database
		var $_draw_html	 = null;	//call draw_html class 

		function language(&$db, $draw_html, $language_id)
		{
			$this->_db=&$db;
			$this->_draw_html=$draw_html;
			$this->language_id=$language_id; 
		}//end function

		//check nunmber language in the table language
		function count_language()
		{
			$sql_sel="SELECT COUNT(*) AS num FROM `#__language` WHERE `active`=1";
			$this->_db->set_query($sql_sel);
			$row=$this->_db->load_result();

			if (!$row) return false;
			return $row;
		}//end function

		//draw the selectbox language
		function selectbox_language($form_name='adminForm', $selected="", $action="", $refesh="", $default=false)
		{
			$sql_sel="SELECT `id`, `language`, `icon` FROM `#__language` WHERE `active`=1";
			if ($default==true) $sql_sel.=" AND `default`!=1";
			$sql_sel.=" ORDER BY `default` DESC";
			//echo $this->_db->get_query();
			$this->_db->set_query($sql_sel);
			$rows=$this->_db->load_record_list();
			
			//echo "<pre>";print_r($rows);echo "</pre>";
			if (!$rows) return false;
			
			for ($i=0; $i<count($rows); $i++)
			{
				$items[]=$this->_draw_html->make_option($rows[$i]["id"]."#".$rows[$i]["icon"], $rows[$i]["language"]);
			}//end for

			if (($action) && ($refesh))
			{
				$onchange='onChange="view_image(\''.$form_name.'\', \'language\', \'icon\', \'./images/\'); this.form.submit();"';
			}else if ($action){
				$onchange='onChange="view_image(\''.$form_name.'\', \'language\', \'icon\', \'./images/\');"';
			}else if ($refesh){
				$onchange='onChange="this.form.submit();"';
			}else{
				$onchange="";
			}//end if
			$box_lanuage = $this->_draw_html->selectbox($items, 'language', 'class="selectbox" size="1" id="language" '.$onchange, 'value', 'text', $selected);
			return $box_lanuage;
		}//end function

		//Get icon of language 
		function flag_icon($language_id)
		{
			$sql_sel="SELECT `icon` FROM `#__language` WHERE `id`=".$language_id;
			$this->_db->set_query($sql_sel);
			$row=$this->_db->load_result();
			if (!$row) return false;
			return $row;
		}//end function

		function language_second()
		{
			$sql_sel="SELECT `id`, `icon` FROM `#__language` WHERE `active`=1 AND `default`!=1 ORDER BY `id` DESC";
			$this->_db->set_query($sql_sel);
			$row=$this->_db->load_record();
			if (!$row) return false;
			return $row;
		}//end function

		//Check language using
		function folder($id)
		{
			$sql_sel="SELECT `access_file` FROM `#__language` WHERE `active`=1 AND `id`=".$id;
			$this->_db->set_query($sql_sel);
			$row=$this->_db->load_result();

			if (!$row) return false;
			return $row;
		}//end function

		//Check charset using
		function charset($id)
		{
			$sql_sel="SELECT `charset` FROM `#__language` WHERE `active`=1 AND `id`=".$id;
			$this->_db->set_query($sql_sel);
			$row=$this->_db->load_result();

			if (!$row) return false;
			return $row;
		}//end function
	}//end class
?>