<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: classes/pages.php 
	# Description: 
	# Write by: Le Hung
	# Start time: December 14, 2007
	# Last update:  
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');
	class pages
	{
		var $limitstart = null;
		var $limit = null;
		var $total = null;
		var $ajax=false;
		var $placeholder=null;

		function pages($total, $limitstart, $limit, $ajax=false) 
		{
			$this->total = intval($total);
			$this->limitstart = max($limitstart, 0);
			$this->limit = max($limit, 5);
			$this->ajax=$ajax;
			
			if ($this->limit > $this->total) 
			{
				$this->limitstart = 0;
			}//end if

			if (($this->limit-1)*$this->limitstart > $this->total) 
			{
				$this->limitstart -= $this->limitstart % $this->limit;
			}//end if
		}//end function

		function pages_counter() 
		{
			$html='';
			$from_result = $this->limitstart+1;
			if ($this->limitstart + $this->limit < $this->total) 
			{
				$to_result = $this->limitstart + $this->limit;
			}else{
				$to_result = $this->total;
			}//end if

			if ($this->total > 0) 
			{
				$html.='\n<span class="bold">'.RESULTS.' '.$from_result. '</span> - <span class="bold">'.$to_result.' '.OF.' '. $this->total.'</span>';
			//}else{
				//echo NO_RECORDS_FOUND;
			}//end if
			return $html;
		}//end function

		function leafs_counter() 
		{
			$html='';
			//$page = $this->limitstart+1;
			$this_page = ceil(($this->limitstart+1) / $this->limit);
			$total_pages = ceil($this->total / $this->limit);
			if ($this->total > 0) {
				$html.=PAGE.': '.$this_page.' '.OF.' '.$total_pages;
			}
			return $html;
		}//end function

		function pages_links($link) 
		{
			$html='';
			$displayed_pages = 24;
			$total_pages = ceil($this->total / $this->limit);
			$this_page = ceil(($this->limitstart+1) / $this->limit);
			$start_loop = (floor(($this_page-1)/$displayed_pages))*$displayed_pages+1;
			
			if ($start_loop + $displayed_pages - 1 < $total_pages) 
			{
				$stop_loop = $start_loop + $displayed_pages - 1;
			}else{
				$stop_loop = $total_pages;
			}//end if

			$link.='&amp;limit='.$this->limit;

			if ($this_page > 1) 
			{
				$page = ($this_page - 2) * $this->limit;
				//$html.='\n&laquo;&laquo; <a href="#beg" title="'.PAGE_START.'" onclick="JavaScript: document.adminForm.limitstart.value=0; document.adminForm.submit();">'.PAGE_START.'</a>';
				//$html.='\n &laquo; <a href="#prev" title="'.PAGE_PREVIOUS.'" onclick="JavaScript: document.adminForm.limitstart.value='.$page.'; document.adminForm.submit();">'.PAGE_PREVIOUS.'</a>';
				$html.=$this->build_url($link."&amp;limitstart=0",'&laquo;&laquo;'.PAGE_START.' ');
				$html.=$this->build_url($link."&amp;limitstart=".$page,'&laquo;'.PAGE_PREVIOUS);
			}else{
				$html.=' &laquo;&laquo;'.PAGE_START;
				$html.=' &laquo;'.PAGE_PREVIOUS;
			}//end if

			for ($i=$start_loop; $i <= $stop_loop; $i++) 
			{
				$page = ($i - 1) * $this->limit;
				if ($i == $this_page) 
				{
					$html.=' <span class="active">'.$i.'</span> ';
				}else{
					//$html.='\n <a href="#$i" onclick="JavaScript: document.adminForm.limitstart.value='.$page.'; document.adminForm.submit();">'.$i.'</a>';
					$html.=$this->build_url($link.'&amp;limitstart='.$page, ' '.$i);
				}//end if
			}//end for

			if ($this_page < $total_pages) 
			{
				$page = $this_page * $this->limit;
				$end_page = ($total_pages-1) * $this->limit;
				//$html.='\n <a href="#next" title="'.PAGE_NEXT.'" onclick="JavaScript: document.adminForm.limitstart.value='.$page.'; document.adminForm.submit();">'.PAGE_NEXT.'</a> &raquo;';
				//$html.='\n <a href="#end" title="'.PAGE_END.'" onclick="JavaScript: document.adminForm.limitstart.value='.$end_page.'; document.adminForm.submit();">'.PAGE_END.'</a> &raquo;&raquo;';
				$html.=$this->build_url($link.'&amp;limitstart='.$page, ' '.PAGE_NEXT.'&raquo;');
				$html.=$this->build_url($link.'&amp;limitstart='.$end_page, ' '.PAGE_END.'&raquo;&raquo;');

			}else{
				$html.=' '.PAGE_NEXT.'&raquo;';
				$html.=' '.PAGE_END.'&raquo;&raquo;';
			}//end if
			return $html;
		}//end function

		function build_url($link, $text)
		{
			global $dir_ws_theme;
			$link=rewite_url($link);
			if ($this->ajax)
			{
				//$html = '<a href="javascript:void(0);" onclick="load_ajax(\''.$link.'\',\''.$this->placeholder.'\')"'.'">'.$text.'</a>';
				//$html = '<a href="javascript:load_ajax(\''.$link.'\',\''.$this->placeholder.'\')"'.'">'.$text.'</a>';
				$html='<a href="JavaScript:void(0);" onClick="getajax(\''.$link.'\', \''.$this->placeholder.'\', \''.LOADING.'\', \''.$dir_ws_theme.'\')">'.$text.'</a>';
			}else{
				$html = '<a href="'. $link .'">'. $text .'</a> ';
			}//end if
			return $html;
		}//end function
		
		function placeholder($holder)
		{
			$this->placeholder=$holder;
		}//end function
	}//end class
?>