<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: 
	# Description: 
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/
	require_once(DIR_FS_CLASSES."customers.request.php");
	require_once(DIR_FS_CLASSES."pet_relocation.php");
	require_once(DIR_FS_CLASSES."locations.php");
	require_once(DIR_FS_CLASSES."draw_html.php");
	require_once(DIR_FS_HTML."email_html.php");
	require_once (DIR_FS_CLASSES.'phpmailer.php');

	$action = trim(get_param($_REQUEST, 'action', ''));
	
	switch ($action)
	{
		case 'save':
			$body=save($db);
			break;
		
		default:
			$body=show($db);
			break;
	}//end switch

	function show(&$db, $error='')
	{
		global $dir_ws_theme, $tpl_path;
		$selectbox=new locations($db);
	
		$country=$selectbox->draw_popup('country_id', 'id', 'name', '', 'class="selectbox" size=1 id="country_id"', SELECT_COUNTRY, 'AND `parent_id`=0');

		$country_of_origin=$selectbox->draw_popup('country_of_origin', 'id', 'name', '', 'class="selectbox" size=1 id="country_of_origin"', SELECT_COUNTRY, 'AND `parent_id`=0');
		$country_of_destination=$selectbox->draw_popup('country_of_destination', 'id', 'name', '', 'class="selectbox" size=1 id="country_of_destination"', SELECT_COUNTRY, 'AND `parent_id`=0');

		$tpl=new tq_smarty();
		$tpl->assign('path_language', DIR_FS_CONFIG);
		$tpl->assign('access', $_SESSION['access']);
		$tpl->assign('dir_ws_theme', $dir_ws_theme);
		$tpl->assign('country', $country);
		$tpl->assign('country_of_origin', $country_of_origin);
		$tpl->assign('country_of_destination', $country_of_destination);
		$tpl->assign('dir_ws_language', DIR_WS_LANGUAGE);
		$tpl->assign('dir_ws_js', DIR_WS_JS);
		$tpl->assign('request_from', REQUEST_FORM);
		$tpl->assign('form_name', PET_RELOCATION);
		if ($error)
		{
			$draw_html = new draw_html($error, $dir_ws_theme);
			$tpl->assign('error', $draw_html->draw_error_form());
		}//end if
		$body=$tpl->fetch($tpl_path.'/pet_relocation.html');
		return $body;
	}//end function

	function save(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$pet_relocation = new form_pet_relocation($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=6;
		$customer->status=1;
		if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$pet_relocation->customer_id = $customer->id;
				if (!$pet_relocation->bind($_POST, $ignore)) $error=$pet_relocation->get_error(); 
				if (!$pet_relocation->check())$error=$pet_relocation->get_error();
				if ($_POST['date_of_travel']) $pet_relocation->date_of_travel=db_date($_POST['date_of_travel']);
				$pet_relocation->create_date  = date("Y-m-d");	
				if(!$error)
					if (!$pet_relocation->store()) $error=$pet_relocation->get_error();
			}//end if
		}//end if
		
		if ($error)
		{
			$body=show($db, $error);
			return $body;
		}else{
			$header_email1=header_email_webmaster($config->person, PET_RELOCATION);
			$header_email2=header_email($_POST['customer'], PET_RELOCATION);
			$customer_content=customer_content($db);
			$pet_relocation_content=pet_relocation_content($db);
			$footer_email=footer_email();

			$send_webmaster=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$pet_relocation_content;
			$send_webmaster.=$footer_email;

			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$pet_relocation_content;
			$send_customer.=$footer_email;

			$customer_email =$_POST['email']; 
			$customer_email = str_replace("; ", ";", $customer_email);
			$customer_email = str_replace(" ;", ";", $customer_email);
			$customer_email = explode(";", $customer_email);
			
			for($i=0; $i<count($customer_email); $i++){
					if($customer->is_email($customer_email[$i])==0){
						unset($customer_email[$i]); 
					}	
			}
			
			$email_list = $config->email; 
			
			$email_config = str_replace("; ", ";", $config->email);
			$email_config = str_replace(" ;", ";", $config->email);
			$email_config = explode(";", $email_config);
			
			for($i=0;$i<count($email_config); $i++){
				for($j=0; $j<count($customer_email); $j++){
					$mail    = new PHPMailer();
					$mail->CharSet = 'UTF-8'; 
				/*	$mail->IsSMTP(); 
					$mail->SMTPAuth = true; */
					$mail->From     = $customer_email[$j];
					$mail->FromName = $_POST['customer'];
					$mail->Subject = sprintf(SUBJECT, PET_RELOCATION, $_POST['customer']);
					$mail->MsgHTML($send_webmaster);
					$mail->AddAddress($email_config[$i], $email_list);
					@$mail->Send();
				}
			}		
			
			for($i=0;$i<count($customer_email);$i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				/*$mail->IsSMTP(); 
				$mail->SMTPAuth = true; */
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = sprintf(SUBJECT2, PET_RELOCATION);
				$mail->MsgHTML($send_customer);
				$mail->AddAddress($customer_email[$i], $_POST['customer']);
				@$mail->Send();
			}
			redirect("?module=contents&id=40");
		}//end if
	}//end function
?>