<?php	
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root:  
	# Description: 
	# Write by: Le Hung
	# Start time: 
	# Last update:  
	*/

	require_once (DIR_FS_CLASSES.'home_search.php');
	require_once(DIR_FS_CLASSES."locations.php");
	require_once(DIR_FS_INCLUDES."sajax.php");

	$action = trim(get_param($_REQUEST, 'action', ''));
	$homes = new homes($db, $default, $_SESSION['language_id']);
	switch ($action)
	{
		case "detail":
			$body=detail($db);
			break;
			
		default:	
			$body=show($db);
			break;
	}//end switch

	function show(&$db)
	{
		global $homes, $dir_ws_theme, $tpl_path;

		$limit = intval(get_param($_REQUEST, 'limit', 10));
		$limitstart = intval(get_param($_REQUEST, 'limitstart', 0));
		$url='?module=home.search';
		$city_id = intval(get_param($_REQUEST, 'city_id', 0));
		$district_id = intval(get_param($_REQUEST, 'district_id', 0));
		$type_id = intval(get_param($_REQUEST, 'type_id', 0));

		$type=$homes->draw_type($type_id, 'class="selectbox" size=1 id="type_id" style="width:160px;"');
		$content=$homes->show($city_id, $district_id, $type_id, $limitstart, $limit, $url);

		//echo '<pre>';print_r($rows);echo '</pre>';

		$selectbox=new locations($db);
		$city=$selectbox->draw_city_district('city_id', '', $city_id, 'class="selectbox" size=1 id="city_id" onChange="get_district();" style="width:160px;"', SELECT_CITY);
		//$disabling=$selectbox->disabling(SELECT_DISTRICT, 'style="width:160px;"');
		if ($city_id) $district=$selectbox->draw_city_district('district_id', $city_id, $district_id, 'class="selectbox" size=1 id="district_id" style="width:160px;"', SELECT_DISTRICT);
		else $district=$selectbox->disabling(SELECT_DISTRICT, 'style="width:160px;"');
		
		sajax_init();
		eval(sajax_export('district'));
		sajax_handle_client_request();
		
		$tpl=new tq_smarty();
		$tpl->assign('path_language', DIR_FS_CONFIG);
		$tpl->assign('dir_ws_photos', DIR_WS_PHOTOS);
		$tpl->assign('dir_ws_js', DIR_WS_JS);
		$tpl->assign('access', $_SESSION['access']);
		$tpl->assign('dir_ws_theme', $dir_ws_theme);
		$tpl->assign('title', HOME_SEARCH);	
		$tpl->assign('city', $city);
		$tpl->assign('district', $district);
		$tpl->assign('type', $type);
		$tpl->assign('district_selected', $district_id);
		$tpl->assign('rows', $content['rows']);
		$tpl->assign('leafs_counter', $content['leafs_counter']);
		$tpl->assign('page_links', $content['page_links']);
		$body=$tpl->fetch($tpl_path.'home_search.html');
		return $body;
	}//end function

	function detail(&$db)
	{
		include (DIR_FS_HTML.'logged.php');	

		global $homes, $dir_ws_theme, $tpl_path;
		$id = intval(get_param($_REQUEST, 'id', 0));
		$row=$homes->detail($id);
		//echo '<pre>';print_r($row);echo '</pre>';

		$tpl=new tq_smarty();
		$tpl->assign('path_language', DIR_FS_CONFIG);
		$tpl->assign('dir_ws_photos', DIR_WS_PHOTOS);
		$tpl->assign('dir_ws_js', DIR_WS_JS);
		$tpl->assign('access', $_SESSION['access']);
		$tpl->assign('dir_ws_theme', $dir_ws_theme);
		$tpl->assign('title', HOME_SEARCH);	

		$tpl->assign('row', $row);
		$body=$tpl->fetch($tpl_path.'home_detail.html');
		return $body;
	}//end function
	
	$smarty->assign('body', $body);
	$smarty->assign('title', HOME_SEARCH);
	$list_language=flag($db, false);
	$smarty->assign('list_language', $list_language);
	$smarty->assign('banner_picture', 'home_search');
	$smarty->display($tpl_path.'template.html');

	function district($city_id, $selected)
	{
		global $db;
		$selectbox=new locations($db);
		return $selectbox->draw_city_district('district_id', $city_id, $selected, 'class="selectbox" size=1 id="district_id" style="width:160px;"', SELECT_DISTRICT);
	}//end function
?>