<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: includes/common.php 
	# Description: 
	# Write by: Le Hung
	# Start time: November 12, 2007
	# Last update:  
	*/

	session_start();
	require_once (DIR_FS_CLASSES."database.php");
	require_once (DIR_FS_CLASSES."inputfilter.php");
	require_once (DIR_FS_CLASSES."language.php");
	require_once (DIR_FS_CLASSES."configuration.php");
	require_once (DIR_FS_INCLUDES."globals.php");
	require_once (DIR_FS_INCLUDES."functions.php");
	require_once (DIR_FS_CLASSES."smarty.php");

	$db = new database(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD, DB_DATABASE, DB_PREFIX);

	$smarty = new tq_smarty;

	$db->set_query("SELECT `folder` FROM `#__templates` WHERE `active`=1");
	$template=$db->load_result();
	if ($template) 
	{
		$dir_ws_theme=DIR_WS_THEMES.$template."/";
		$tpl_path=DIR_FS_THEMES.$template."/";
	}else{ 
		$dir_ws_theme=DIR_WS_THEMES."default/";
		$tpl_path=DIR_FS_THEMES."default/";
	}//end if
	
	$smarty->template_dir = $tpl_path;
	$smarty->assign("tpl_path", $tpl_path);
	$smarty->assign("dir_ws_html", DIR_WS_HTML);
	$smarty->assign("path_language", DIR_FS_CONFIG);
	$smarty->assign("dir_ws_theme", $dir_ws_theme);
	$smarty->assign("dir_ws_js", DIR_WS_JS);
	$smarty->assign("dir_ws_language", DIR_WS_LANGUAGE);
	

	//check templates_c is exists and writable
	if (!is_dir($smarty->compile_dir) && !file_exists($smarty->compile_dir))
        @mkdir($smarty->compile_dir, 0777);

	//warning when templates_c is not writable
    if (!is_writable($smarty->compile_dir) || !is_dir($smarty->compile_dir))
	{
	    echo "Can't write template cache in the directory: <b>".$smarty->compile_dir."</b>.<br>Please check if it exists, and have writable permissions.";
    	exit();
    }//end if

	//config site
	$config = new configuration($db);
	$config ->load(1);
	//echo '<pre>';print_r($config);echo '</pre>';

	//make phpsession
	if (!isset($_SESSION["phpsession"])) $_SESSION["phpsession"]="hb_".session_id();

	//language
	$default=language_default($db);

	$language=trim(strtolower(get_param($_GET, 'language', $default['code'] )));
	if (isset($_GET['language']) && ($_GET['language']!=''))
	{
		change_language($db, $_GET['language']);
	}//end if

	if (!isset($_SESSION['language_id']))
	{
		$_SESSION['language_id']=$default['id'];
		$_SESSION['access']=$default['access_file'];
		$_SESSION['charset']=$default['charset'];
	}//end if

	$smarty->assign("show_language", flag($db));
	$smarty->assign("access", $_SESSION['access']);
	$smarty->assign("site_name", $config->sitename);
	$smarty->assign("charset", $_SESSION['charset']);
	$smarty->assign("meta_keyword", $config->meta_keyword);
	$smarty->assign("meta_description", $config->meta_description);

	require_once (DIR_FS_LANGUAGE.$_SESSION['access']."/frontend.php");
	require_once (DIR_FS_LANGUAGE.$_SESSION['access']."/functions.php");

	header("Content-type:text/html; charset=".$_SESSION['charset']."\"");

	function language_default(&$db)
	{
		$sql_sel="SELECT * FROM `#__language` WHERE `active`=1 AND `default`=1";
		$db->set_query($sql_sel);
		$row=$db->load_record();

		if (!$row) return false;
		return $row;
	}//end function

	function change_language(&$db, $language)
	{
		global $default;
		if ($language)
		{
			$db->set_query("SELECT * FROM `#__language` WHERE `code`='".$language."'");
			$row=$db->load_record();
			
			if ($row)
			{
				$_SESSION['language_id']=$row['id'];
				$_SESSION['access']=$row['access_file'];
				$_SESSION['charset']=$row['charset'];
			}//end if
		}//end if
		return false;
	}//end function

	function flag(&$db, $list=true)
	{
		global $dir_ws_theme;
		$sql='SELECT `code`, `icon`, `language` FROM `#__language`';
		if ($list==false) $sql.=' WHERE `id`!='.$_SESSION['language_id'];
		$sql.=' ORDER BY `id` ASC';
		$db->set_query($sql);
		$rows=$db->load_record_list();
		if (!$rows) return false;
		
		$html='';
		$url=explode('&language', $_SERVER['QUERY_STRING']);
		$url[0]=($url[0])?$url[0]:'module=contents';
		foreach ($rows as $row)
		{
			$html.='<a href="?'.$url[0].'&language='.$row['code'].'"><img src="'.$dir_ws_theme.'images/'.$row['icon'].'" border="0" align="absmiddle" /> '.$row['language'].'</a> ';
		}//end freach
		return $html;
	}//end function
?>
